/*
 * Decompiled with CFR 0.152.
 */
package com.ca.mas.foundation;

import android.net.Uri;
import com.ca.mas.core.conf.ConfigurationManager;
import com.ca.mas.foundation.MASClaims;
import com.ca.mas.foundation.MASConfiguration;
import com.ca.mas.foundation.MASConnectionListener;
import com.ca.mas.foundation.MASGrantProvider;
import com.ca.mas.foundation.MASRequestBody;
import com.ca.mas.foundation.MASResponseBody;
import com.ca.mas.foundation.MASSecurityConfiguration;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.security.PrivateKey;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public interface MASRequest {
    public URL getURL();

    public String getMethod();

    public Map<String, List<String>> getHeaders();

    public MASGrantProvider getGrantProvider();

    public MASRequestBody getBody();

    public MASConnectionListener getConnectionListener();

    public MASResponseBody getResponseBody();

    public String getScope();

    public boolean isPublic();

    public boolean notifyOnCancel();

    public static class MASRequestBuilder {
        private URL url;
        private String method = Method.GET.name();
        private Map<String, List<String>> headers = new HashMap<String, List<String>>();
        private MASRequestBody body;
        private MASResponseBody<?> responseBody = new MASResponseBody();
        private MASGrantProvider grantProvider = ConfigurationManager.getInstance().getDefaultGrantProvider();
        private String scope;
        private MASConnectionListener listener;
        private boolean isPublic;
        private long timeout;
        private TimeUnit timeUnit;
        private boolean notifyOnCancel = false;
        private boolean sign = false;
        private MASClaims claim;
        private PrivateKey privateKey;

        private boolean isAbsolute(String scheme) {
            if (scheme != null) {
                String s = scheme.toLowerCase();
                return s.startsWith("https") || s.startsWith("http");
            }
            return false;
        }

        public MASRequestBuilder(URI uri) {
            if (uri != null) {
                try {
                    this.url = !this.isAbsolute(uri.getScheme()) ? ConfigurationManager.getInstance().getConnectedGatewayConfigurationProvider().getUri(uri.toString()).toURL() : uri.toURL();
                }
                catch (MalformedURLException e) {
                    throw new IllegalArgumentException(e);
                }
            }
        }

        public MASRequestBuilder(Uri uri) {
            if (uri != null) {
                try {
                    this.url = !this.isAbsolute(uri.getScheme()) ? ConfigurationManager.getInstance().getConnectedGatewayConfigurationProvider().getUri(uri.toString()).toURL() : new URL(uri.toString());
                }
                catch (MalformedURLException e) {
                    throw new IllegalArgumentException(e);
                }
            }
        }

        public MASRequestBuilder(URL url) {
            this.url = url;
        }

        public MASRequestBuilder(MASRequest request) {
            this.method = request.getMethod();
            this.body = request.getBody();
            this.grantProvider = request.getGrantProvider();
            this.scope = request.getScope();
            this.responseBody = request.getResponseBody();
            this.isPublic = request.isPublic();
            this.headers = request.getHeaders();
            this.listener = request.getConnectionListener();
            this.url = request.getURL();
        }

        public MASRequestBuilder get() {
            this.method = Method.GET.name();
            this.body = null;
            return this;
        }

        public MASRequestBuilder post(MASRequestBody body) {
            this.method = Method.POST.name();
            this.body = body;
            return this;
        }

        public MASRequestBuilder put(MASRequestBody body) {
            this.method = Method.PUT.name();
            this.body = body;
            return this;
        }

        public MASRequestBuilder patch(MASRequestBody body) {
            this.method = Method.PATCH.name();
            this.body = body;
            return this;
        }

        public MASRequestBuilder delete(MASRequestBody body) {
            this.method = Method.DELETE.name();
            this.body = body;
            return this;
        }

        public MASRequestBuilder password() {
            this.grantProvider = MASGrantProvider.PASSWORD;
            return this;
        }

        public MASRequestBuilder clientCredential() {
            this.grantProvider = MASGrantProvider.CLIENT_CREDENTIALS;
            return this;
        }

        public MASRequestBuilder scope(String scope) {
            this.scope = scope;
            return this;
        }

        public MASRequestBuilder responseBody(MASResponseBody responseBody) {
            this.responseBody = responseBody;
            return this;
        }

        public MASRequestBuilder setPublic() {
            this.isPublic = true;
            return this;
        }

        public MASRequestBuilder header(String name, String value) {
            List<String> values = this.headers.get(name);
            if (values == null) {
                values = new ArrayList<String>();
                this.headers.put(name, values);
            }
            values.add(value);
            return this;
        }

        public MASRequestBuilder removeHeader(String name) {
            this.headers.remove(name);
            return this;
        }

        public MASRequestBuilder connectionListener(MASConnectionListener listener) {
            this.listener = listener;
            return this;
        }

        public MASRequestBuilder notifyOnCancel() {
            this.notifyOnCancel = true;
            return this;
        }

        public MASRequestBuilder sign() {
            this.sign = true;
            return this;
        }

        public MASRequestBuilder sign(MASClaims claim) {
            this.sign = true;
            this.claim = claim;
            return this;
        }

        public MASRequestBuilder sign(PrivateKey privateKey) {
            this.sign = true;
            this.privateKey = privateKey;
            return this;
        }

        public MASRequest build() {
            HashMap newHeaders = new HashMap();
            for (String key : this.headers.keySet()) {
                ArrayList<String> headerValues = new ArrayList<String>();
                if (this.headers.get(key) != null) {
                    for (String value : this.headers.get(key)) {
                        headerValues.add(value);
                    }
                }
                newHeaders.put(key, Collections.unmodifiableList(headerValues));
            }
            final Map unmodifiableHeaders = Collections.unmodifiableMap(newHeaders);
            if (!this.isPublic && this.url != null) {
                Uri uri = Uri.parse((String)this.url.toString());
                MASSecurityConfiguration config = MASConfiguration.getCurrentConfiguration().getSecurityConfiguration(uri);
                if (config != null && config.isPublic()) {
                    this.setPublic();
                }
            }
            return new MASRequest(){

                @Override
                public URL getURL() {
                    return MASRequestBuilder.this.url;
                }

                @Override
                public String getMethod() {
                    return MASRequestBuilder.this.method;
                }

                @Override
                public Map<String, List<String>> getHeaders() {
                    return unmodifiableHeaders;
                }

                @Override
                public MASGrantProvider getGrantProvider() {
                    return MASRequestBuilder.this.grantProvider;
                }

                @Override
                public MASConnectionListener getConnectionListener() {
                    return MASRequestBuilder.this.listener;
                }

                @Override
                public String getScope() {
                    return MASRequestBuilder.this.scope;
                }

                @Override
                public boolean isPublic() {
                    return MASRequestBuilder.this.isPublic;
                }

                @Override
                public boolean notifyOnCancel() {
                    return MASRequestBuilder.this.notifyOnCancel;
                }

                @Override
                public MASRequestBody getBody() {
                    if (MASRequestBuilder.this.sign && MASRequestBuilder.this.body != null) {
                        return MASRequestBody.jwtClaimsBody(MASRequestBuilder.this.claim, MASRequestBuilder.this.privateKey, MASRequestBuilder.this.body);
                    }
                    return MASRequestBuilder.this.body;
                }

                @Override
                public MASResponseBody<?> getResponseBody() {
                    return MASRequestBuilder.this.responseBody;
                }
            };
        }
    }

    public static enum Method {
        GET,
        PUT,
        POST,
        DELETE,
        PATCH;

    }
}

