/*
 * Decompiled with CFR 0.152.
 */
package com.ca.mas.foundation;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Parcelable;
import android.util.Log;
import com.ca.mas.core.auth.otp.OtpUtil;
import com.ca.mas.core.auth.otp.model.OtpResponseHeaders;
import com.ca.mas.foundation.MAS;
import com.ca.mas.foundation.MASAuthenticationListener;
import com.ca.mas.foundation.MASMultiFactorAuthenticator;
import com.ca.mas.foundation.MASOtpAuthenticationHandler;
import com.ca.mas.foundation.MASRequest;
import com.ca.mas.foundation.MASResponse;

public class MASOtpMultiFactorAuthenticator
extends MASMultiFactorAuthenticator<MASOtpAuthenticationHandler> {
    @Override
    public MASOtpAuthenticationHandler getMultiFactorHandler(long requestId, MASRequest request, MASResponse<?> response) {
        int statusCode = response.getResponseCode();
        if (statusCode == 400 || statusCode == 401 || statusCode == 403) {
            OtpResponseHeaders otpResponseHeaders = OtpUtil.getXotpValueFromHeaders(response.getHeaders());
            if (OtpResponseHeaders.X_OTP_VALUE.REQUIRED == otpResponseHeaders.getxOtpValue()) {
                return new MASOtpAuthenticationHandler(requestId, otpResponseHeaders.getChannels(), false);
            }
            if (OtpResponseHeaders.X_CA_ERROR.OTP_INVALID == otpResponseHeaders.getErrorCode()) {
                return new MASOtpAuthenticationHandler(requestId, otpResponseHeaders.getChannels(), true);
            }
        }
        return null;
    }

    @Override
    protected void onMultiFactorAuthenticationRequest(Context context, MASRequest originalRequest, MASResponse<?> response, MASOtpAuthenticationHandler handler) {
        if (MAS.getAuthenticationListener() == null) {
            Class<Activity> otpActivity = this.getOtpActivity();
            if (otpActivity != null) {
                if (context != null) {
                    Intent intent = new Intent(context, otpActivity);
                    intent.addFlags(0x10000000);
                    intent.putExtra("com.ca.mas.core.service.req.extra.auth.otp.handler", (Parcelable)handler);
                    context.startActivity(intent);
                }
            } else if (MAS.DEBUG) {
                Log.w((String)"MAS", (String)(MASAuthenticationListener.class.getSimpleName() + " is required for otp authentication."));
            }
        } else {
            MAS.getAuthenticationListener().onOtpAuthenticateRequest((Context)MAS.getCurrentActivity(), handler);
        }
    }

    private Class<Activity> getOtpActivity() {
        try {
            return Class.forName("com.ca.mas.ui.otp.MASOtpActivity");
        }
        catch (Exception e) {
            return null;
        }
    }
}

