/*
 * Decompiled with CFR 0.152.
 */
package com.ca.mas.foundation;

import androidx.annotation.NonNull;
import com.ca.mas.core.MobileSso;
import com.ca.mas.core.MobileSsoFactory;
import com.ca.mas.core.auth.ble.BluetoothLePeripheral;
import com.ca.mas.core.context.DeviceIdentifier;
import com.ca.mas.foundation.DeviceMetadata;
import com.ca.mas.foundation.MAS;
import com.ca.mas.foundation.MASCallback;
import com.ca.mas.foundation.auth.MASProximityLoginBLEPeripheralListener;
import com.ca.mas.foundation.notify.Callback;
import org.json.JSONArray;
import org.json.JSONObject;

public abstract class MASDevice {
    private static MASDevice current;

    public abstract void deregister(MASCallback<Void> var1);

    public abstract boolean isRegistered();

    public abstract void resetLocally();

    public abstract String getIdentifier();

    public abstract void startAsBluetoothPeripheral(MASProximityLoginBLEPeripheralListener var1);

    public abstract void stopAsBluetoothPeripheral();

    private MASDevice() {
    }

    public static MASDevice getCurrentDevice() {
        if (current == null) {
            current = new MASDevice(){

                @Override
                public void deregister(final MASCallback<Void> callback) {
                    final MobileSso mobileSso = MobileSsoFactory.getInstance();
                    if (mobileSso != null && mobileSso.isDeviceRegistered()) {
                        Thread t = new Thread(new Runnable(){

                            @Override
                            public void run() {
                                try {
                                    mobileSso.removeDeviceRegistration();
                                    Callback.onSuccess(callback, null);
                                }
                                catch (Exception e) {
                                    Callback.onError(callback, e);
                                }
                            }
                        });
                        t.start();
                    } else {
                        Callback.onError(callback, new IllegalStateException("Device is not registered"));
                    }
                }

                @Override
                public boolean isRegistered() {
                    return MobileSsoFactory.getInstance().isDeviceRegistered();
                }

                @Override
                public void resetLocally() {
                    MobileSsoFactory.getInstance().destroyAllPersistentTokens();
                }

                @Override
                public String getIdentifier() {
                    try {
                        return new DeviceIdentifier().toString();
                    }
                    catch (Exception e) {
                        throw new IllegalArgumentException("Keystore is not available", e);
                    }
                }

                @Override
                public void startAsBluetoothPeripheral(MASProximityLoginBLEPeripheralListener listener) {
                    BluetoothLePeripheral bleServer = BluetoothLePeripheral.getInstance();
                    bleServer.init(MAS.getContext());
                    bleServer.start(listener);
                }

                @Override
                public void stopAsBluetoothPeripheral() {
                    BluetoothLePeripheral.getInstance().stop();
                }
            };
        }
        return current;
    }

    public void addAttribute(@NonNull String attr, String value, MASCallback<Void> callback) {
        DeviceMetadata.putAttribute(attr, value, callback);
    }

    public void removeAllAttributes(MASCallback<Void> callback) {
        DeviceMetadata.deleteAttributes(callback);
    }

    public void removeAttribute(@NonNull String attr, MASCallback<Void> callback) {
        DeviceMetadata.deleteAttribute(attr, callback);
    }

    public void getAttribute(@NonNull String attr, MASCallback<JSONObject> callback) {
        DeviceMetadata.getAttribute(attr, callback);
    }

    public void getAttributes(MASCallback<JSONArray> callback) {
        DeviceMetadata.getAttributes(callback);
    }
}

