/*
 * Decompiled with CFR 0.152.
 */
package com.ca.mas.core.util;

import android.net.Uri;
import com.ca.mas.foundation.MAS;
import com.ca.mas.foundation.MASException;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;

public class FileUtils {
    public static byte[] getBytesFromPath(String path) throws MASException, IOException {
        byte[] bytes = new byte[]{};
        try (InputStream is = null;){
            File file = new File(path);
            bytes = new byte[(int)file.length()];
            is = new FileInputStream(file);
            is.read(bytes);
        }
        return bytes;
    }

    public static byte[] getBytesFromUri(Uri uri) throws MASException, IOException {
        byte[] bytes;
        try (InputStream inputStream = null;){
            inputStream = MAS.getContext().getContentResolver().openInputStream(uri);
            bytes = FileUtils.getBytes(inputStream);
        }
        return bytes;
    }

    private static byte[] getBytes(InputStream inputStream) throws IOException {
        ByteArrayOutputStream byteBuffer = new ByteArrayOutputStream();
        int bufferSize = 1024;
        byte[] buffer = new byte[bufferSize];
        int len = 0;
        while ((len = inputStream.read(buffer)) != -1) {
            byteBuffer.write(buffer, 0, len);
        }
        return byteBuffer.toByteArray();
    }

    public static String getFileTyepFromUri(Uri uri) {
        return MAS.getContext().getContentResolver().getType(uri);
    }
}

