/*
 * Decompiled with CFR 0.152.
 */
package com.ca.mas.core.token;

import android.content.SharedPreferences;
import android.os.AsyncTask;
import android.util.Base64;
import android.util.Log;
import androidx.annotation.NonNull;
import com.ca.mas.core.MASCallbackFuture;
import com.ca.mas.core.conf.ConfigurationManager;
import com.ca.mas.core.context.MssoContext;
import com.ca.mas.core.http.MAGHttpClient;
import com.ca.mas.core.token.IdToken;
import com.ca.mas.core.token.IdTokenDef;
import com.ca.mas.core.token.JWTValidationException;
import com.ca.mas.core.token.JWTValidator;
import com.ca.mas.foundation.MAS;
import com.ca.mas.foundation.MASCallback;
import com.ca.mas.foundation.MASConfiguration;
import com.ca.mas.foundation.MASRequest;
import com.ca.mas.foundation.MASResponse;
import com.ca.mas.foundation.MASResponseBody;
import com.ca.mas.foundation.notify.Callback;
import com.nimbusds.jose.JOSEException;
import com.nimbusds.jose.JWSVerifier;
import com.nimbusds.jose.crypto.RSASSAVerifier;
import com.nimbusds.jose.jwk.JWK;
import com.nimbusds.jose.jwk.JWKSet;
import com.nimbusds.jose.jwk.RSAKey;
import com.nimbusds.jwt.SignedJWT;
import java.io.IOException;
import java.net.URL;
import java.text.ParseException;
import java.util.concurrent.ExecutionException;
import org.json.JSONException;
import org.json.JSONObject;

public class JWTRS256Validator
implements JWTValidator {
    public static final String TAG = JWTRS256Validator.class.getSimpleName();
    private static final String WELL_KNOW_URI = "/.well-known/openid-configuration";
    private static final String JWKS_URI = "jwks_uri";
    private static final String KID = "kid";
    public static final String JWT_KEY_SET_FILE = "jwks_store";
    private static String jwks;

    public JWTRS256Validator() {
        if (jwks == null) {
            String keySet;
            SharedPreferences prefs = MAS.getContext().getSharedPreferences(JWT_KEY_SET_FILE, 0);
            jwks = keySet = prefs.getString(ConfigurationManager.getInstance().getConnectedGateway().getHost(), null);
        }
    }

    private static void resetPrefs() {
        SharedPreferences prefs = MAS.getContext().getSharedPreferences(JWT_KEY_SET_FILE, 0);
        SharedPreferences.Editor editor = prefs.edit();
        editor.clear();
        editor.apply();
    }

    @Override
    public boolean validate(MssoContext context, @NonNull IdToken idToken) throws JWTValidationException {
        boolean isSignatureValid;
        String kid;
        IdTokenDef idTokenDef = new IdTokenDef(idToken);
        try {
            kid = this.getKid(new String(Base64.decode((byte[])idTokenDef.getHeader(), (int)8)));
        }
        catch (JWTValidationException e) {
            throw new JWTValidationException(13101, (Throwable)e);
        }
        try {
            JWK publicKey = this.getJwk(kid);
            if (publicKey == null) {
                jwks = null;
                JWTRS256Validator.resetPrefs();
                publicKey = this.getJwk(kid);
            }
            if (publicKey == null) {
                throw new JWTValidationException(13101);
            }
            RSASSAVerifier verifier = new RSASSAVerifier((RSAKey)publicKey);
            SignedJWT signedJWT = SignedJWT.parse((String)idToken.getValue());
            isSignatureValid = signedJWT.verify((JWSVerifier)verifier);
        }
        catch (JOSEException | InterruptedException | ParseException | ExecutionException e) {
            throw new JWTValidationException(13101, e);
        }
        return isSignatureValid;
    }

    private JWK getJwk(String kid) throws InterruptedException, ExecutionException, ParseException {
        MASCallbackFuture<String> masCallbackFuture = new MASCallbackFuture<String>();
        this.loadJWKS(masCallbackFuture);
        String result = masCallbackFuture.get();
        JWKSet jwkSet = JWKSet.parse((String)result);
        return jwkSet.getKeyByKeyId(kid);
    }

    public void loadJWKS(@NonNull MASCallbackFuture<String> callback) {
        if (jwks != null) {
            Callback.onSuccess(callback, jwks);
            return;
        }
        new JwksLoadAsynTask().execute(new MASCallback[]{callback});
    }

    private String getKid(String header) throws JWTValidationException {
        try {
            JSONObject jsonObject = new JSONObject(header);
            return jsonObject.getString(KID);
        }
        catch (JSONException e) {
            Log.w((String)TAG, (String)"JWT header is not JSON Object");
            throw new JWTValidationException(13101, e.getMessage(), e);
        }
    }

    public static String getJwks() {
        return jwks;
    }

    public static void setJwks(String jwks) {
        JWTRS256Validator.jwks = jwks;
    }

    static class JwksLoadAsynTask
    extends AsyncTask<MASCallback<String>, Void, Void> {
        JwksLoadAsynTask() {
        }

        private static void writeJwtKeySetToPrefs(String jwks) {
            SharedPreferences prefs = MAS.getContext().getSharedPreferences(JWTRS256Validator.JWT_KEY_SET_FILE, 0);
            SharedPreferences.Editor editor = prefs.edit();
            editor.putString(ConfigurationManager.getInstance().getConnectedGateway().getHost(), jwks);
            editor.apply();
        }

        protected Void doInBackground(MASCallback<String> ... params) {
            MASCallback<String> callback = params[0];
            try {
                URL request_well_know_uri = new URL(MASConfiguration.getCurrentConfiguration().getGatewayUrl() + JWTRS256Validator.WELL_KNOW_URI);
                MAGHttpClient client = new MAGHttpClient();
                MASRequest request = new MASRequest.MASRequestBuilder(request_well_know_uri).responseBody(MASResponseBody.jsonBody()).setPublic().build();
                MASResponse response = client.execute(request);
                JSONObject jsonObject = (JSONObject)response.getBody().getContent();
                String jwksUri = jsonObject.getString(JWTRS256Validator.JWKS_URI);
                MASRequest request_jks_uri = new MASRequest.MASRequestBuilder(new URL(jwksUri)).setPublic().build();
                response = client.execute(request_jks_uri);
                jwks = ((JSONObject)response.getBody().getContent()).toString();
                JwksLoadAsynTask.writeJwtKeySetToPrefs(jwks);
                if (MAS.DEBUG) {
                    Log.d((String)TAG, (String)("JWT Key Set = " + jwks));
                }
                Callback.onSuccess(callback, jwks);
            }
            catch (IOException e) {
                Callback.onError(callback, e);
            }
            catch (JSONException e) {
                Callback.onError(callback, e);
            }
            return null;
        }
    }
}

