/*
 * Decompiled with CFR 0.152.
 */
package com.ca.mas.core.store;

import androidx.annotation.NonNull;
import com.ca.mas.core.conf.ConfigurationManager;
import com.ca.mas.core.datasource.DataSource;
import com.ca.mas.core.datasource.DataSourceException;
import com.ca.mas.core.store.OAuthTokenContainer;

public class PrivateTokenStorage
implements OAuthTokenContainer {
    private DataSource<String, String> storage;

    public PrivateTokenStorage(@NonNull DataSource storage) {
        this.storage = storage;
    }

    @Override
    public void saveAccessToken(String accessToken, String refreshToken, long expiresInSec, String grantedScope) {
        long now = System.currentTimeMillis();
        long expiresInMillis = expiresInSec * 1000L;
        long expiry = now + expiresInMillis;
        this.storage.put(this.getKey(KEY.PREF_ACCESS_TOKEN.name()), accessToken);
        this.storage.put(this.getKey(KEY.PREF_REFRESH_TOKEN.name()), refreshToken);
        this.storage.put(this.getKey(KEY.PREF_EXPIRY_UNIXTIME.name()), Long.toString(expiry));
        this.storage.put(this.getKey(KEY.PREF_GRANTED_SCOPE.name()), grantedScope);
    }

    @Override
    public String getAccessToken() {
        try {
            return this.storage.get(this.getKey(KEY.PREF_ACCESS_TOKEN.name()));
        }
        catch (DataSourceException e) {
            return null;
        }
    }

    @Override
    public String getRefreshToken() {
        try {
            return this.storage.get(this.getKey(KEY.PREF_REFRESH_TOKEN.name()));
        }
        catch (DataSourceException e) {
            return null;
        }
    }

    @Override
    public synchronized String takeRefreshToken() {
        String refreshToken = this.getRefreshToken();
        if (refreshToken != null) {
            this.storage.remove(this.getKey(KEY.PREF_REFRESH_TOKEN.name()));
        }
        return refreshToken;
    }

    @Override
    public String getGrantedScope() {
        try {
            return this.storage.get(this.getKey(KEY.PREF_GRANTED_SCOPE.name()));
        }
        catch (DataSourceException e) {
            return null;
        }
    }

    @Override
    public long getExpiry() {
        try {
            String r = this.storage.get(this.getKey(KEY.PREF_EXPIRY_UNIXTIME.name()));
            if (r != null) {
                return Long.parseLong(r);
            }
            return 0L;
        }
        catch (DataSourceException e) {
            return 0L;
        }
    }

    @Override
    public void clear() {
        for (KEY k : KEY.values()) {
            this.storage.remove(this.getKey(k.name()));
        }
    }

    @Override
    public void clearAll() {
        this.storage.removeAll(null);
    }

    private String getKey(String name) {
        return ConfigurationManager.getInstance().getConnectedGateway().toString() + name;
    }

    public static enum KEY {
        PREF_ACCESS_TOKEN,
        PREF_REFRESH_TOKEN,
        PREF_EXPIRY_UNIXTIME,
        PREF_GRANTED_SCOPE,
        PREF_ID_TOKEN,
        PREF_ID_TOKEN_TYPE;

    }
}

