/*
 * Decompiled with CFR 0.152.
 */
package com.ca.mas.core.store;

import androidx.annotation.NonNull;
import com.ca.mas.core.conf.ConfigurationManager;
import com.ca.mas.core.datasource.DataSource;
import com.ca.mas.core.store.ClientCredentialContainer;
import com.ca.mas.core.token.ClientCredentials;

public class ClientCredentialStorage
implements ClientCredentialContainer {
    private DataSource<String, String> storage;

    public ClientCredentialStorage(@NonNull DataSource storage) {
        this.storage = storage;
    }

    @Override
    public void saveClientCredentials(ClientCredentials clientCredentials) {
        if (clientCredentials != null) {
            this.storage.put(this.getKey(KEY.PREF_MASTER_CLIENT_ID.name()), clientCredentials.getMasterClientId());
            this.storage.put(this.getKey(KEY.PREF_CLIENT_ID.name()), clientCredentials.getClientId());
            this.storage.put(this.getKey(KEY.PREF_CLIENT_SECRET.name()), clientCredentials.getClientSecret());
            this.storage.put(this.getKey(KEY.PREF_CLIENT_EXPIRE_TIME.name()), Long.toString(clientCredentials.getClientExpiration()));
        }
    }

    @Override
    public String getMasterClientId() {
        return this.storage.get(this.getKey(KEY.PREF_MASTER_CLIENT_ID.name()));
    }

    @Override
    public Long getClientExpiration() {
        String r = this.storage.get(this.getKey(KEY.PREF_CLIENT_EXPIRE_TIME.name()));
        if (r != null) {
            return Long.parseLong(r);
        }
        return -1L;
    }

    @Override
    public String getClientId() {
        return this.storage.get(this.getKey(KEY.PREF_CLIENT_ID.name()));
    }

    @Override
    public String getClientSecret() {
        return this.storage.get(this.getKey(KEY.PREF_CLIENT_SECRET.name()));
    }

    @Override
    public void clear() {
        for (KEY k : KEY.values()) {
            this.storage.remove(this.getKey(k.name()));
        }
    }

    @Override
    public void clearAll() {
        this.storage.removeAll(null);
    }

    private String getKey(String name) {
        return ConfigurationManager.getInstance().getConnectedGateway().toString() + name;
    }

    static enum KEY {
        PREF_MASTER_CLIENT_ID,
        PREF_CLIENT_ID,
        PREF_CLIENT_SECRET,
        PREF_CLIENT_EXPIRE_TIME;

    }
}

