/*
 * Decompiled with CFR 0.152.
 */
package com.ca.mas.core.storage.implementation;

import android.accounts.Account;
import android.accounts.AccountManager;
import android.content.Context;
import android.util.Base64;
import android.util.Log;
import androidx.annotation.Keep;
import com.ca.mas.core.storage.Storage;
import com.ca.mas.core.storage.StorageException;
import com.ca.mas.core.storage.StorageResult;
import com.ca.mas.core.storage.StorageResultReceiver;
import com.ca.mas.core.storage.implementation.AMSSManager;
import com.ca.mas.core.storage.implementation.MASStorageManager;
import com.ca.mas.foundation.MAS;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;

@Keep
public class AccountManagerStorage
extends Storage {
    private static final int SQLITE_MAX_LENGTH = 1000000000;
    private static final int MAX_DATA_SIZE = 1000000000;
    private static final int MAX_KEY_SIZE = 1000000000;
    private static final String KEYINDEX_COLUMN_NAME = "lookup_index";
    private String mPrefix = "";
    private Context mContext;
    private AccountIndexFormatter mFormatter;
    private AMSSManager accountManager;

    protected AccountManagerStorage(Object options) throws StorageException {
        super(options);
        try {
            if (options == null || !(options instanceof Object[])) {
                throw new StorageException(111);
            }
            Object[] inputs = (Object[])options;
            try {
                this.mContext = (Context)inputs[0];
                this.mContext.getPackageName();
            }
            catch (Exception e) {
                if (MAS.DEBUG) {
                    Log.e((String)"MAS", (String)("Missing Context input " + e));
                }
                throw new StorageException(111);
            }
            try {
                this.mPrefix = (Boolean)inputs[1] != false ? "SHARED_" : this.mContext.getPackageName() + "_";
            }
            catch (Exception e) {
                if (MAS.DEBUG) {
                    Log.w((String)"MAS", (String)("Wrong shared input attribute, falling back to private" + e));
                }
                this.mPrefix = this.mContext.getPackageName() + "_";
            }
            this.accountManager = AMSSManager.getInstance(this.mContext);
            this.mFormatter = new AccountIndexFormatter();
        }
        catch (StorageException bubble) {
            throw bubble;
        }
        catch (Exception e) {
            if (MAS.DEBUG) {
                Log.e((String)"MAS", (String)"Failed to initialize storage", (Throwable)e);
            }
            throw new StorageException(106);
        }
    }

    @Override
    public MASStorageManager.MASStorageType getType() {
        return MASStorageManager.MASStorageType.TYPE_AMS;
    }

    private StorageResult writeData(String key, byte[] value, int option) throws StorageException {
        StorageResult returnValue = new StorageResult(StorageResult.StorageOperationType.WRITE);
        StorageException returnException = null;
        this.validateInputs(key, value);
        try {
            byte[] keyBytes = (this.mPrefix + key).getBytes("UTF-8");
            String encodedKey = Base64.encodeToString((byte[])keyBytes, (int)0);
            String data = this.readAccountData(this.mContext, encodedKey);
            switch (option) {
                case 0: {
                    if (data == null) break;
                    returnException = new StorageException(104);
                    break;
                }
                case 1: {
                    if (data != null) break;
                    returnException = new StorageException(105);
                    break;
                }
            }
            if (returnException == null) {
                String encodedValue = Base64.encodeToString((byte[])value, (int)0);
                this.writeAccountData(this.mContext, encodedKey, encodedValue);
            }
        }
        catch (Exception e) {
            if (MAS.DEBUG) {
                Log.e((String)"MAS", (String)"Error writing data ", (Throwable)e);
            }
            returnException = new StorageException(110);
        }
        if (returnException != null) {
            returnValue.setStatus(StorageResult.StorageOperationStatus.FAILURE);
            returnValue.setData(returnException);
        } else {
            returnValue.setStatus(StorageResult.StorageOperationStatus.SUCCESS);
            returnValue.setData(key);
        }
        return returnValue;
    }

    @Override
    public StorageResult writeData(String key, byte[] value) throws StorageException {
        return this.writeData(key, value, 0);
    }

    @Override
    public void writeData(String key, byte[] value, StorageResultReceiver callback) throws StorageException {
        StorageResult result = this.writeData(key, value);
        this.notifyCallback(callback, result);
    }

    @Override
    public StorageResult writeString(String key, String value) throws StorageException {
        this.validateInputs(key, value);
        try {
            StorageResult result = this.writeData(key, value.getBytes("UTF-8"), 0);
            result.setType(StorageResult.StorageOperationType.WRITE_STRING);
            return result;
        }
        catch (UnsupportedEncodingException e) {
            throw new StorageException(111);
        }
    }

    @Override
    public void writeString(String key, String value, StorageResultReceiver callback) throws StorageException {
        StorageResult result = this.writeString(key, value);
        this.notifyCallback(callback, result);
    }

    @Override
    public StorageResult readData(String key) throws StorageException {
        StorageResult returnValue = new StorageResult(StorageResult.StorageOperationType.READ);
        StorageException returnException = null;
        if (key == null) {
            throw new StorageException(101);
        }
        if (key.length() > 1000000000) {
            throw new StorageException(151);
        }
        try {
            byte[] keyBytes = (this.mPrefix + key).getBytes("UTF-8");
            String encodedKey = Base64.encodeToString((byte[])keyBytes, (int)0);
            String data = this.readAccountData(this.mContext, encodedKey);
            if (data == null) {
                returnException = new StorageException(105);
            } else {
                byte[] retrievedData = Base64.decode((byte[])data.getBytes("UTF-8"), (int)0);
                if (retrievedData == null) {
                    returnException = new StorageException(110);
                } else {
                    returnValue.setData(retrievedData);
                }
            }
        }
        catch (Exception e) {
            if (MAS.DEBUG) {
                Log.e((String)"MAS", (String)"Error Writing data ", (Throwable)e);
            }
            returnException = new StorageException(110);
        }
        if (returnException != null) {
            returnValue.setStatus(StorageResult.StorageOperationStatus.FAILURE);
            returnValue.setData(returnException);
        } else {
            returnValue.setStatus(StorageResult.StorageOperationStatus.SUCCESS);
        }
        return returnValue;
    }

    @Override
    public void readData(String key, StorageResultReceiver callback) throws StorageException {
        StorageResult result = this.readData(key);
        this.notifyCallback(callback, result);
    }

    @Override
    public StorageResult readString(String key) throws StorageException {
        if (key == null) {
            throw new StorageException(101);
        }
        if (key.length() > 1000000000) {
            throw new StorageException(151);
        }
        StorageResult returnValue = this.readData(key);
        if (returnValue.getStatus() != StorageResult.StorageOperationStatus.FAILURE) {
            try {
                returnValue.setData(new String((byte[])returnValue.getData(), "UTF-8"));
            }
            catch (UnsupportedEncodingException e) {
                if (MAS.DEBUG) {
                    Log.w((String)"MAS", (String)"UTF-8 decoding of the data failed, reverting to system default");
                }
                returnValue.setData(new String((byte[])returnValue.getData()));
            }
        }
        returnValue.setType(StorageResult.StorageOperationType.READ_STRING);
        return returnValue;
    }

    @Override
    public void readString(String key, StorageResultReceiver callback) throws StorageException {
        StorageResult result = this.readString(key);
        this.notifyCallback(callback, result);
    }

    @Override
    public StorageResult updateData(String key, byte[] value) throws StorageException {
        StorageResult result = this.writeData(key, value, 1);
        result.setType(StorageResult.StorageOperationType.UPDATE);
        return result;
    }

    @Override
    public void updateData(String key, byte[] value, StorageResultReceiver callback) throws StorageException {
        StorageResult result = this.updateData(key, value);
        this.notifyCallback(callback, result);
    }

    @Override
    public StorageResult updateString(String key, String value) throws StorageException {
        this.validateInputs(key, value);
        try {
            StorageResult result = this.writeData(key, value.getBytes("UTF-8"), 1);
            result.setType(StorageResult.StorageOperationType.UPDATE_STRING);
            return result;
        }
        catch (UnsupportedEncodingException e) {
            throw new StorageException(111);
        }
    }

    @Override
    public void updateString(String key, String value, StorageResultReceiver callback) throws StorageException {
        StorageResult result = this.updateString(key, value);
        this.notifyCallback(callback, result);
    }

    @Override
    public StorageResult writeOrUpdateData(String key, byte[] value) throws StorageException {
        StorageResult result = this.writeData(key, value, 2);
        result.setType(StorageResult.StorageOperationType.WRITE_OR_UPDATE);
        return result;
    }

    @Override
    public void writeOrUpdateData(String key, byte[] value, StorageResultReceiver callback) throws StorageException {
        StorageResult result = this.writeOrUpdateData(key, value);
        this.notifyCallback(callback, result);
    }

    @Override
    public StorageResult writeOrUpdateString(String key, String value) throws StorageException {
        this.validateInputs(key, value);
        try {
            StorageResult result = this.writeOrUpdateData(key, value.getBytes("UTF-8"));
            result.setType(StorageResult.StorageOperationType.WRITE_OR_UPDATE_STRING);
            return result;
        }
        catch (UnsupportedEncodingException e) {
            throw new StorageException(111);
        }
    }

    @Override
    public void writeOrUpdateString(String key, String value, StorageResultReceiver callback) throws StorageException {
        StorageResult result = this.writeOrUpdateString(key, value);
        this.notifyCallback(callback, result);
    }

    @Override
    public StorageResult deleteData(String key) throws StorageException {
        StorageResult returnValue = new StorageResult(StorageResult.StorageOperationType.DELETE);
        StorageException returnException = null;
        if (key == null) {
            throw new StorageException(101);
        }
        if (key.length() > 1000000000) {
            throw new StorageException(151);
        }
        try {
            byte[] keyBytes = (this.mPrefix + key).getBytes("UTF-8");
            String encodedKey = Base64.encodeToString((byte[])keyBytes, (int)0);
            String data = this.readAccountData(this.mContext, encodedKey);
            if (data == null) {
                returnException = new StorageException(105);
            } else {
                this.writeAccountData(this.mContext, encodedKey, null);
            }
        }
        catch (Exception e) {
            if (MAS.DEBUG) {
                Log.e((String)"MAS", (String)"Error writing data ", (Throwable)e);
            }
            returnException = new StorageException(110);
        }
        if (returnException != null) {
            returnValue.setStatus(StorageResult.StorageOperationStatus.FAILURE);
            returnValue.setData(returnException);
        } else {
            returnValue.setStatus(StorageResult.StorageOperationStatus.SUCCESS);
            returnValue.setData(key);
        }
        return returnValue;
    }

    @Override
    public StorageResult deleteString(String key) throws StorageException {
        StorageResult result = this.deleteData(key);
        result.setType(StorageResult.StorageOperationType.DELETE_STRING);
        return result;
    }

    @Override
    public void deleteData(String key, StorageResultReceiver callback) throws StorageException {
        StorageResult result = this.deleteData(key);
        this.notifyCallback(callback, result);
    }

    @Override
    public void deleteString(String key, StorageResultReceiver callback) throws StorageException {
        StorageResult result = this.deleteString(key);
        this.notifyCallback(callback, result);
    }

    @Override
    public StorageResult deleteAll() {
        StorageResult returnValue = new StorageResult(StorageResult.StorageOperationType.DELETE_ALL);
        StorageException returnError = null;
        int successCount = 0;
        int failureCount = 0;
        try {
            StorageResult keyQuery = this.getAllKeys();
            ArrayList keys = (ArrayList)keyQuery.getData();
            for (String currentKey : keys) {
                try {
                    StorageResult deleteQuery = this.deleteData(currentKey);
                    if (deleteQuery.getStatus() == StorageResult.StorageOperationStatus.FAILURE) {
                        ++failureCount;
                        continue;
                    }
                    ++successCount;
                }
                catch (Exception e) {
                    ++failureCount;
                }
            }
            if (failureCount != 0) {
                String msg = "Failed to deleteData " + failureCount + " entries. Entries deleted: " + successCount;
                if (MAS.DEBUG) {
                    Log.e((String)"MAS", (String)msg);
                }
                returnError = new StorageException(msg, null, 110);
            } else if (MAS.DEBUG) {
                Log.i((String)"MAS", (String)("Deleted " + successCount + " entries "));
            }
        }
        catch (Exception e) {
            if (MAS.DEBUG) {
                Log.e((String)"MAS", (String)"deleteAll failed ", (Throwable)e);
            }
            returnError = new StorageException(110);
        }
        if (returnError != null) {
            returnValue.setStatus(StorageResult.StorageOperationStatus.FAILURE);
            returnValue.setData(returnError);
        } else {
            returnValue.setStatus(StorageResult.StorageOperationStatus.SUCCESS);
            returnValue.setData(successCount);
        }
        return returnValue;
    }

    @Override
    public void deleteAll(StorageResultReceiver callback) throws StorageException {
        StorageResult returnValue = this.deleteAll();
        this.notifyCallback(callback, returnValue);
    }

    @Override
    public StorageResult getAllKeys() {
        StorageResult returnValue = new StorageResult(StorageResult.StorageOperationType.GET_ALL_KEYS);
        StorageException returnError = null;
        ArrayList keys = new ArrayList();
        try {
            String keyBlob = this.readAccountData(this.mContext, KEYINDEX_COLUMN_NAME);
            keys = this.mFormatter.unmarshal(keyBlob, true);
        }
        catch (Exception e) {
            returnError = new StorageException(110);
        }
        if (returnError != null) {
            returnValue.setStatus(StorageResult.StorageOperationStatus.FAILURE);
            returnValue.setData(returnError);
        } else {
            returnValue.setStatus(StorageResult.StorageOperationStatus.SUCCESS);
            returnValue.setData(keys);
        }
        return returnValue;
    }

    @Override
    public void getAllKeys(StorageResultReceiver callback) throws StorageException {
        StorageResult returnValue = this.getAllKeys();
        this.notifyCallback(callback, returnValue);
    }

    private void notifyCallback(StorageResultReceiver callback, StorageResult result) {
        block4: {
            if (callback == null && MAS.DEBUG) {
                Log.w((String)"MAS", (String)"No AccountManagerStorage callback set.");
            }
            if (callback != null) {
                try {
                    callback.send(result);
                }
                catch (Exception e) {
                    if (!MAS.DEBUG) break block4;
                    Log.w((String)"MAS", (String)"AccountManagerStorage threw exception: ", (Throwable)e);
                }
            }
        }
    }

    private void updateAccountKeyIndex(Context ctx, String key, String value) throws Exception {
        AccountManager am = AccountManager.get((Context)ctx);
        Account account = this.accountManager.getAccount();
        String keyBlob = this.readAccountData(ctx, KEYINDEX_COLUMN_NAME);
        ArrayList keyList = this.mFormatter.unmarshal(keyBlob, false);
        if (value == null) {
            if (keyList.contains(key)) {
                keyList.remove(key);
            }
        } else if (!keyList.contains(key)) {
            keyList.add(key);
        }
        keyBlob = this.mFormatter.marshal(keyList, false);
        am.setUserData(account, KEYINDEX_COLUMN_NAME, keyBlob);
    }

    private void writeAccountData(Context ctx, String encodedKey, String value) throws Exception {
        AccountManager am = AccountManager.get((Context)ctx);
        Account account = this.accountManager.getAccount();
        if (value == null) {
            this.updateAccountKeyIndex(ctx, encodedKey, null);
            am.setUserData(account, encodedKey, null);
        } else {
            am.setUserData(account, encodedKey, value);
            this.updateAccountKeyIndex(ctx, encodedKey, value);
        }
    }

    private String readAccountData(Context ctx, String key) throws Exception {
        AccountManager am = AccountManager.get((Context)ctx);
        Account account = this.accountManager.getAccount();
        return am.getUserData(account, key);
    }

    private void validateInputs(String key, String value) throws StorageException {
        byte[] byteData;
        if (key == null) {
            throw new StorageException(101);
        }
        if (value == null) {
            throw new StorageException(102);
        }
        if (key.length() > 1000000000) {
            throw new StorageException(113);
        }
        try {
            byteData = value.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new StorageException(109);
        }
        if (byteData.length > 1000000000) {
            throw new StorageException(114);
        }
    }

    private void validateInputs(String key, byte[] value) throws StorageException {
        if (key == null) {
            throw new StorageException(101);
        }
        if (key.length() > 1000000000) {
            throw new StorageException(113);
        }
        if (value == null) {
            throw new StorageException(102);
        }
        if (value.length > 1000000000) {
            throw new StorageException(114);
        }
    }

    private class AccountIndexFormatter {
        private static final String ACCOUNT_KEY_SEPARATOR = ":";

        private AccountIndexFormatter() {
        }

        private String marshal(ArrayList<String> items, boolean encode) {
            if (items == null || items.size() == 0) {
                return "";
            }
            try {
                StringBuffer buff = new StringBuffer();
                Iterator<String> iterator = items.iterator();
                while (iterator.hasNext()) {
                    String keyElement;
                    String modifiedKey = keyElement = iterator.next();
                    if (encode) {
                        modifiedKey = Base64.encodeToString((byte[])(AccountManagerStorage.this.mPrefix + keyElement).getBytes("UTF-8"), (int)0);
                    }
                    buff.append(modifiedKey);
                    buff.append(ACCOUNT_KEY_SEPARATOR);
                }
                String keyBlob = buff.toString();
                keyBlob = keyBlob.endsWith(ACCOUNT_KEY_SEPARATOR) ? keyBlob.substring(0, keyBlob.length() - 1) : keyBlob;
                return keyBlob;
            }
            catch (Exception e) {
                if (MAS.DEBUG) {
                    Log.e((String)"MAS", (String)("Error in marshal: " + e));
                }
                return "";
            }
        }

        private ArrayList<String> unmarshal(String blob, boolean decode) {
            ArrayList<String> keys;
            block7: {
                keys = new ArrayList<String>();
                if (blob == null || blob.length() == 0) {
                    return keys;
                }
                try {
                    ArrayList<String> temp = new ArrayList<String>(Arrays.asList(blob.split(ACCOUNT_KEY_SEPARATOR)));
                    if (decode) {
                        for (String key : temp) {
                            byte[] decodedData = Base64.decode((byte[])key.getBytes("UTF-8"), (int)0);
                            if (decodedData != null) {
                                String sanitizedKey = new String(decodedData, "UTF-8");
                                if (!sanitizedKey.startsWith(AccountManagerStorage.this.mPrefix)) continue;
                                keys.add(sanitizedKey.substring(AccountManagerStorage.this.mPrefix.length()));
                                continue;
                            }
                            if (!MAS.DEBUG) continue;
                            Log.w((String)"MAS", (String)"Unable to process key retrieved from store");
                        }
                    } else {
                        keys = temp;
                    }
                }
                catch (UnsupportedEncodingException e) {
                    if (!MAS.DEBUG) break block7;
                    Log.e((String)"MAS", (String)("Error in unmarshal: " + e));
                }
            }
            return keys;
        }
    }
}

