/*
 * Decompiled with CFR 0.152.
 */
package com.ca.mas.core.service;

import android.util.Log;
import androidx.annotation.NonNull;
import com.ca.mas.foundation.MAS;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

class MssoExecutorService {
    private static final int CPU_COUNT = Runtime.getRuntime().availableProcessors();
    private static final int CORE_POOL_SIZE = CPU_COUNT + 1;
    private static final int MAXIMUM_POOL_SIZE = CPU_COUNT * 2 + 1;
    private static final int KEEP_ALIVE = 5;
    private static final BlockingQueue<Runnable> POOL_WORK_QUEUE = new LinkedBlockingQueue<Runnable>(128);
    private static final ThreadFactory THREAD_FACTORY = new ThreadFactory(){
        private final AtomicInteger increment = new AtomicInteger(1);

        @Override
        public Thread newThread(@NonNull Runnable r) {
            int count = this.increment.getAndIncrement();
            if (MAS.DEBUG) {
                Log.w((String)"MAS", (String)("MssoService thread " + count + " created."));
            }
            return new Thread(r, "MssoServiceThread" + count);
        }
    };
    private static ExecutorService executor;

    public static ExecutorService getInstance() {
        if (executor == null || executor.isShutdown()) {
            executor = new ThreadPoolExecutor(CORE_POOL_SIZE, MAXIMUM_POOL_SIZE, 5L, TimeUnit.SECONDS, POOL_WORK_QUEUE, THREAD_FACTORY);
        }
        return executor;
    }

    private MssoExecutorService() {
    }
}

