/*
 * Decompiled with CFR 0.152.
 */
package com.ca.mas.core.security;

import android.security.keystore.KeyGenParameterSpec;
import androidx.annotation.RequiresApi;
import com.ca.mas.core.security.AndroidKeyStoreRepository;
import com.ca.mas.core.security.GenerateKeyAttribute;
import java.math.BigInteger;
import java.security.spec.AlgorithmParameterSpec;
import java.util.Calendar;
import java.util.Date;
import javax.security.auth.x500.X500Principal;

@RequiresApi(api=23)
public class AndroidMKeyRepository
extends AndroidKeyStoreRepository {
    KeyGenParameterSpec.Builder getKeyGenParameterSpecBuilder(String alias, GenerateKeyAttribute attributes) {
        Calendar cal = Calendar.getInstance();
        Date now = cal.getTime();
        cal.add(1, 1);
        Date end = cal.getTime();
        return new KeyGenParameterSpec.Builder(alias, 15).setKeySize(attributes.getKeySize()).setCertificateNotBefore(now).setCertificateNotAfter(end).setCertificateSubject(new X500Principal("CN=msso")).setCertificateSerialNumber(BigInteger.valueOf(1L)).setUserAuthenticationRequired(attributes.isUserAuthenticationRequired()).setUserAuthenticationValidityDurationSeconds(attributes.getUserAuthenticationValidityDurationSeconds()).setRandomizedEncryptionRequired(false).setBlockModes(new String[]{"CBC", "CTR", "ECB", "GCM"}).setDigests(new String[]{"NONE", "MD5", "SHA-1", "SHA-256", "SHA-384", "SHA-512"}).setEncryptionPaddings(new String[]{"PKCS7Padding", "OAEPPadding", "PKCS1Padding"}).setSignaturePaddings(new String[]{"PSS", "PKCS1"});
    }

    @Override
    AlgorithmParameterSpec getAlgorithmParameterSpec(String alias, GenerateKeyAttribute attributes) {
        return this.getKeyGenParameterSpecBuilder(alias, attributes).build();
    }
}

