/*
 * Decompiled with CFR 0.152.
 */
package com.ca.mas.core.security;

import android.security.KeyPairGeneratorSpec;
import androidx.annotation.RequiresApi;
import com.ca.mas.core.security.AndroidKeyStoreRepository;
import com.ca.mas.core.security.GenerateKeyAttribute;
import com.ca.mas.core.security.KeyStoreException;
import com.ca.mas.foundation.MAS;
import java.math.BigInteger;
import java.security.spec.AlgorithmParameterSpec;
import java.util.Calendar;
import java.util.Date;
import javax.security.auth.x500.X500Principal;

@RequiresApi(api=18)
public class AndroidJellyBeanMR2KeyRepository
extends AndroidKeyStoreRepository {
    @Override
    AlgorithmParameterSpec getAlgorithmParameterSpec(String alias, GenerateKeyAttribute attribute) throws KeyStoreException {
        return this.getKeyPairGeneratorSpecBuilder(alias, attribute).build();
    }

    KeyPairGeneratorSpec.Builder getKeyPairGeneratorSpecBuilder(String alias, GenerateKeyAttribute attributes) {
        Calendar cal = Calendar.getInstance();
        Date now = cal.getTime();
        cal.add(1, 1);
        Date end = cal.getTime();
        KeyPairGeneratorSpec.Builder builder = new KeyPairGeneratorSpec.Builder(MAS.getContext()).setAlias(alias).setStartDate(now).setEndDate(end).setSerialNumber(BigInteger.valueOf(1L)).setSubject(new X500Principal(attributes.getDn()));
        if (attributes.isEncryptionRequired()) {
            builder.setEncryptionRequired();
        }
        return builder;
    }
}

