/*
 * Decompiled with CFR 0.152.
 */
package com.ca.mas.core.io.ssl;

import androidx.annotation.NonNull;
import com.ca.mas.core.io.http.SingleKeyX509KeyManager;
import com.ca.mas.core.io.http.TrustedCertificateConfigurationTrustManager;
import com.ca.mas.core.io.ssl.TLSSocketFactory;
import com.ca.mas.core.store.StorageProvider;
import com.ca.mas.foundation.MASConfiguration;
import com.ca.mas.foundation.MASSecurityConfiguration;
import java.security.PrivateKey;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;

public class MAGSocketFactory {
    private static final String SSL_TLS_PROTOCOL = "TLS";
    private static final SecureRandom secureRandom = new SecureRandom();
    private MASSecurityConfiguration securityConfiguration;
    private PrivateKey clientCertPrivateKey = null;
    private X509Certificate[] clientCertChain = null;

    public MAGSocketFactory(@NonNull MASSecurityConfiguration config) {
        this.securityConfiguration = config;
        try {
            if (MASConfiguration.getCurrentConfiguration() != null) {
                this.clientCertPrivateKey = StorageProvider.getInstance().getTokenManager().getClientPrivateKey();
                this.clientCertChain = StorageProvider.getInstance().getTokenManager().getClientCertificateChain();
            }
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    public SSLSocketFactory createTLSSocketFactory() {
        return new TLSSocketFactory(this.createSslContext().getSocketFactory());
    }

    private SSLContext createSslContext() {
        try {
            KeyManager[] keyManagerArray;
            SSLContext sslContext = SSLContext.getInstance(SSL_TLS_PROTOCOL);
            TrustedCertificateConfigurationTrustManager manager = new TrustedCertificateConfigurationTrustManager(this.securityConfiguration);
            TrustManager[] trustManagers = new TrustManager[]{manager};
            if (this.clientCertPrivateKey == null || this.clientCertChain == null) {
                keyManagerArray = new KeyManager[]{};
            } else {
                KeyManager[] keyManagerArray2 = new KeyManager[1];
                keyManagerArray = keyManagerArray2;
                keyManagerArray2[0] = new SingleKeyX509KeyManager(this.clientCertPrivateKey, this.clientCertChain);
            }
            KeyManager[] keyManagers = keyManagerArray;
            sslContext.init(keyManagers, trustManagers, secureRandom);
            return sslContext;
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to create SSL Context: " + e.getMessage(), e);
        }
    }
}

