/*
 * Decompiled with CFR 0.152.
 */
package com.ca.mas.core.datasource;

import android.content.ComponentName;
import android.content.Context;
import android.content.pm.PackageManager;
import android.os.Bundle;
import android.util.Log;
import androidx.annotation.Keep;
import com.ca.mas.core.datasource.DataConverter;
import com.ca.mas.core.datasource.DataSource;
import com.ca.mas.core.datasource.DataSourceCallback;
import com.ca.mas.core.storage.MASSecureSharedStorage;
import com.ca.mas.core.storage.sharedstorage.MASAuthenticatorService;
import com.ca.mas.foundation.MAS;
import java.util.List;
import org.json.JSONObject;

@Keep
public class MASSecureStorageDataSource<K, V>
implements DataSource<K, V> {
    private MASSecureSharedStorage storage;
    private Context context;
    private DataConverter converter;
    private static final String ACCOUNT_NAME = "account.name";
    private static final String CA_MAS = "CA MAS Secure";

    public MASSecureStorageDataSource(Context context, JSONObject param, DataConverter conv) {
        if (param == null) {
            return;
        }
        boolean shared = param.optBoolean("share", false);
        this.converter = conv;
        this.context = context;
        this.storage = new MASSecureSharedStorage(this.getAccountName(), true, shared, this.converter == null);
    }

    @Override
    public void put(K key, V value) {
        if (this.isKeyString(key)) {
            return;
        }
        String keyString = (String)key;
        if (value == null) {
            this.remove(key);
            return;
        }
        if (value instanceof byte[]) {
            this.storage.save(keyString, (byte[])value);
        } else if (value instanceof String) {
            this.storage.save(keyString, (String)value);
        } else {
            if (MAS.DEBUG) {
                Log.e((String)"MAS", (String)"Value type not supported");
            }
            throw new UnsupportedOperationException("Value type not supported");
        }
    }

    @Override
    public void put(K key, V value, DataSourceCallback callback) {
        throw new UnsupportedOperationException();
    }

    @Override
    public V get(K key) {
        Object retValue;
        block2: {
            retValue = null;
            String keyString = (String)key;
            try {
                retValue = this.converter == null ? this.storage.getBytes(keyString) : (Object)this.storage.getString(keyString);
            }
            catch (UnsupportedOperationException e) {
                if (!MAS.DEBUG) break block2;
                Log.e((String)"MAS", (String)e.getMessage());
            }
        }
        return (V)retValue;
    }

    @Override
    public void get(K key, DataSourceCallback callback) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void remove(K key) {
        if (this.isKeyString(key)) {
            return;
        }
        String keyString = (String)key;
        this.storage.delete(keyString);
    }

    @Override
    public void remove(K key, DataSourceCallback callback) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void removeAll(Object filter) {
        this.storage.removeAll();
    }

    @Override
    public void removeAll(Object filter, DataSourceCallback callback) {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<K> getKeys(Object filter) {
        return this.storage.getKeys();
    }

    @Override
    public void getKeys(Object filter, DataSourceCallback callback) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isReady() {
        return true;
    }

    @Override
    public void unlock() {
        throw new UnsupportedOperationException();
    }

    private boolean isKeyString(Object key) {
        return !(key instanceof String);
    }

    private String getAccountName() {
        ComponentName myService = new ComponentName(this.context, MASAuthenticatorService.class);
        try {
            Bundle data = this.context.getPackageManager().getServiceInfo((ComponentName)myService, (int)128).metaData;
            int resourceId = data.getInt(ACCOUNT_NAME);
            if (resourceId != 0) {
                return this.context.getResources().getString(resourceId);
            }
            return data.getString(ACCOUNT_NAME, CA_MAS);
        }
        catch (PackageManager.NameNotFoundException e) {
            if (MAS.DEBUG) {
                Log.d((String)"MAS", (String)String.format("Account name is not provided, use %S", CA_MAS));
            }
            return CA_MAS;
        }
    }
}

