/*
 * Decompiled with CFR 0.152.
 */
package com.ca.mas.core.conf;

import org.json.JSONException;
import org.json.JSONObject;

public class Server {
    private String host;
    private int port;
    private String prefix;

    public Server(JSONObject config) {
        try {
            JSONObject server = config.getJSONObject("server");
            this.host = server.getString("hostname");
            this.port = server.optInt("port");
            this.prefix = server.optString("prefix");
        }
        catch (JSONException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public Server(String host, int port, String prefix) {
        this.host = host;
        this.port = port;
        this.prefix = prefix;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Server server = (Server)o;
        if (this.port != server.port) {
            return false;
        }
        if (this.host != null ? !this.host.equals(server.host) : server.host != null) {
            return false;
        }
        return this.prefix != null ? this.prefix.equals(server.prefix) : server.prefix == null;
    }

    public int hashCode() {
        int result = this.host != null ? this.host.hashCode() : 0;
        result = 31 * result + this.port;
        result = 31 * result + (this.prefix != null ? this.prefix.hashCode() : 0);
        return result;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.host).append(":").append(this.port).append("/").append(this.prefix).append("/");
        return sb.toString();
    }
}

