/*
 * Decompiled with CFR 0.152.
 */
package com.ca.mas.identity.common;

import android.support.annotation.NonNull;
import com.ca.mas.foundation.MASRequest;
import com.ca.mas.identity.common.MASFilteredRequestBuilder;

class FilterFormatter {
    private MASFilteredRequestBuilder.Operator mOp;
    private MASFilteredRequestBuilder.Logical mLogical;
    private String mAttribute;
    private String mFilterValue;
    private String mLhs;
    private String mRhs;

    FilterFormatter(@NonNull MASFilteredRequestBuilder.Logical logical, MASRequest lhs, MASRequest rhs) {
        this.mLogical = logical;
        this.mLhs = lhs.getURL().getQuery();
        this.mRhs = rhs.getURL().getQuery();
    }

    FilterFormatter(MASFilteredRequestBuilder.Operator op, String attribute, String filterValue) {
        this.mOp = op;
        this.mAttribute = attribute;
        this.mFilterValue = filterValue;
    }

    public String toString() {
        if (this.mOp != null) {
            return this.toStringOperator();
        }
        return this.toStringLogical();
    }

    private String toStringOperator() {
        StringBuilder sb = new StringBuilder();
        sb.append("filter");
        sb.append("=");
        sb.append(this.mAttribute);
        sb.append("%20");
        sb.append((Object)this.mOp);
        if (this.mOp == MASFilteredRequestBuilder.Operator.pr) {
            return sb.toString();
        }
        sb.append("%20");
        sb.append("%22");
        sb.append(this.mFilterValue);
        sb.append("%22");
        return sb.toString();
    }

    private String toStringLogical() {
        StringBuilder sb = new StringBuilder();
        this.mLhs = this.retrieveQueryNoPag(this.mLhs);
        sb.append(this.mLhs);
        sb.append("%20");
        sb.append(this.mLogical.toString());
        sb.append("%20");
        this.mRhs = this.retrieveQueryNoPag(this.mRhs);
        sb.append(this.mRhs);
        return sb.toString();
    }

    private String retrieveQueryNoPag(String query) {
        int index = query.indexOf("startIndex=");
        if (index > -1) {
            return query.substring(0, index);
        }
        return query;
    }
}

