/*
 * Decompiled with CFR 0.152.
 */
package com.ca.mas.identity.common;

import android.content.Context;
import android.content.SharedPreferences;
import android.support.annotation.NonNull;
import android.text.TextUtils;
import com.ca.mas.foundation.MAS;
import com.ca.mas.foundation.MASTransformable;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.json.JSONException;
import org.json.JSONObject;

public abstract class Attributes
implements MASTransformable {
    protected List<String> mAttributes;

    public Attributes() {
        this.mAttributes = new ArrayList<String>();
    }

    public Attributes(List<String> attributes) {
        this.mAttributes = attributes;
    }

    @Override
    public abstract void populate(@NonNull JSONObject var1) throws JSONException;

    @Override
    public JSONObject getAsJSONObject() throws JSONException {
        return null;
    }

    public void save(Context context) {
        SharedPreferences prefs = context.getSharedPreferences(this.getKey(), 0);
        SharedPreferences.Editor editor = prefs.edit();
        StringBuilder sb = new StringBuilder();
        for (String s : this.mAttributes) {
            sb.append(s);
            sb.append(":");
        }
        editor.putString(this.getKey(), sb.toString());
        editor.apply();
    }

    public void clear(Context context) {
        SharedPreferences prefs = context.getSharedPreferences(this.getKey(), 0);
        SharedPreferences.Editor editor = prefs.edit();
        editor.clear();
        editor.apply();
        if (this.mAttributes != null) {
            this.mAttributes.clear();
        }
    }

    public List<String> getAttributes() {
        if (this.mAttributes != null && !this.mAttributes.isEmpty()) {
            return this.mAttributes;
        }
        SharedPreferences prefs = MAS.getContext().getSharedPreferences(this.getKey(), 0);
        String attrs = prefs.getString(this.getKey(), null);
        if (attrs != null) {
            StringTokenizer st = new StringTokenizer(attrs, ":");
            while (st.hasMoreTokens()) {
                String tok = st.nextToken();
                if (TextUtils.isEmpty((CharSequence)tok)) continue;
                this.mAttributes.add(tok);
            }
        }
        return this.mAttributes;
    }

    protected abstract String getKey();
}

