/*
 * Decompiled with CFR 0.152.
 */
package com.ca.mas.foundation;

import com.ca.mas.core.context.MssoContext;
import com.ca.mas.core.util.Functions;
import com.ca.mas.foundation.MASAuthCredentials;
import com.ca.mas.foundation.MASAuthCredentialsClientCredentials;
import java.net.URI;

public enum MASGrantProvider {
    PASSWORD(new Functions.Unary<MASAuthCredentials, MssoContext>(){

        @Override
        public MASAuthCredentials call(MssoContext context) {
            return context.getCredentials();
        }
    }, new Functions.Unary<URI, MssoContext>(){

        @Override
        public URI call(MssoContext context) {
            return context.getConfigurationProvider().getTokenUri("msso.url.register_device");
        }
    }, new Functions.Nullary<Boolean>(){

        @Override
        public Boolean call() {
            return true;
        }
    }),
    CLIENT_CREDENTIALS(new Functions.Unary<MASAuthCredentials, MssoContext>(){

        @Override
        public MASAuthCredentials call(MssoContext context) {
            return new MASAuthCredentialsClientCredentials();
        }
    }, new Functions.Unary<URI, MssoContext>(){

        @Override
        public URI call(MssoContext context) {
            return context.getConfigurationProvider().getTokenUri("msso.url.register_device_client");
        }
    }, new Functions.Nullary<Boolean>(){

        @Override
        public Boolean call() {
            return false;
        }
    });

    private final Functions.Unary<MASAuthCredentials, MssoContext> getCredentials;
    private final Functions.Unary<URI, MssoContext> getRegistrationPath;
    private final Functions.Nullary<Boolean> isSessionSupported;

    private MASGrantProvider(Functions.Unary<MASAuthCredentials, MssoContext> getCredentials, Functions.Unary<URI, MssoContext> getRegistrationPath, Functions.Nullary<Boolean> isSessionSupported) {
        this.getCredentials = getCredentials;
        this.getRegistrationPath = getRegistrationPath;
        this.isSessionSupported = isSessionSupported;
    }

    public MASAuthCredentials getCredentials(MssoContext context) {
        return this.getCredentials.call(context);
    }

    public URI getRegistrationPath(MssoContext context) {
        return this.getRegistrationPath.call(context);
    }

    public boolean isSessionSupported() {
        return this.isSessionSupported.call();
    }
}

