/*
 * Decompiled with CFR 0.152.
 */
package com.ca.mas.foundation;

import android.net.Uri;
import com.ca.mas.foundation.AuthClientDefaults;

public class MASAuthorizationRequest {
    private String clientId;
    private String display;
    private Uri redirectUri;
    private String responseType;
    private String scope;
    private String state;

    private MASAuthorizationRequest(MASAuthorizationRequestBuilder builder) {
        this.clientId = builder.clientId;
        this.display = builder.display;
        this.redirectUri = builder.redirectUri;
        this.responseType = builder.responseType;
        this.scope = builder.scope;
        this.state = builder.state;
    }

    public String getClientId() {
        return this.clientId;
    }

    public String getDisplay() {
        return this.display;
    }

    public Uri getRedirectUri() {
        return this.redirectUri;
    }

    public String getResponseType() {
        return this.responseType;
    }

    public String getScope() {
        return this.scope;
    }

    public String getState() {
        return this.state;
    }

    public static class MASAuthorizationRequestBuilder {
        private String clientId;
        private String display;
        private Uri redirectUri;
        private String responseType;
        private String scope;
        private String state;

        public MASAuthorizationRequest buildDefault() {
            AuthClientDefaults defaults = new AuthClientDefaults();
            this.display = defaults.getDisplay();
            this.clientId = defaults.getClientId();
            this.responseType = defaults.getResponseType();
            this.redirectUri = defaults.getRedirectUri();
            this.scope = defaults.getScope();
            this.state = defaults.getState();
            return new MASAuthorizationRequest(this);
        }

        public MASAuthorizationRequest build() {
            return new MASAuthorizationRequest(this);
        }

        public Uri getRedirectUri() {
            return this.redirectUri;
        }

        public void setRedirectUri(Uri redirectUri) {
            this.redirectUri = redirectUri;
        }

        public String getClientId() {
            return this.clientId;
        }

        public void setClientId(String clientId) {
            this.clientId = clientId;
        }

        public String getDisplay() {
            return this.display;
        }

        public void setDisplay(String display) {
            this.display = display;
        }

        public String getResponseType() {
            return this.responseType;
        }

        public void setResponseType(String responseType) {
            this.responseType = responseType;
        }

        public String getScope() {
            return this.scope;
        }

        public void setScope(String scope) {
            this.scope = scope;
        }

        public String getState() {
            return this.state;
        }

        public void setState(String state) {
            this.state = state;
        }
    }
}

