/*
 * Decompiled with CFR 0.152.
 */
package com.ca.mas.foundation;

import android.os.Parcel;
import android.os.Parcelable;
import android.util.Pair;
import com.ca.mas.core.conf.ConfigurationManager;
import com.ca.mas.core.oauth.CodeVerifierCache;
import com.ca.mas.foundation.MASAuthCredentials;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class MASAuthCredentialsAuthorizationCode
implements MASAuthCredentials {
    private String code;
    private String state;
    private String codeVerifier;
    public static final Parcelable.Creator<MASAuthCredentialsAuthorizationCode> CREATOR = new Parcelable.Creator<MASAuthCredentialsAuthorizationCode>(){

        public MASAuthCredentialsAuthorizationCode createFromParcel(Parcel source) {
            return new MASAuthCredentialsAuthorizationCode(source);
        }

        public MASAuthCredentialsAuthorizationCode[] newArray(int size) {
            return new MASAuthCredentialsAuthorizationCode[size];
        }
    };

    public MASAuthCredentialsAuthorizationCode(String code, String state) {
        this.code = code;
        this.state = state;
        if (ConfigurationManager.getInstance().isPKCEEnabled()) {
            this.codeVerifier = state != null && !state.isEmpty() ? CodeVerifierCache.getInstance().take(state) : CodeVerifierCache.getInstance().take();
        }
    }

    @Override
    public void clear() {
    }

    @Override
    public boolean isValid() {
        return this.code != null && this.code.length() > 0;
    }

    @Override
    public Map<String, List<String>> getHeaders() {
        HashMap<String, List<String>> headers = new HashMap<String, List<String>>();
        ArrayList<String> authorizationValue = new ArrayList<String>();
        authorizationValue.add("Bearer " + this.code);
        headers.put("authorization", authorizationValue);
        String redirectUrl = (String)ConfigurationManager.getInstance().getConnectedGatewayConfigurationProvider().getProperty("msso.authorize.redirect.uri");
        if (redirectUrl != null) {
            ArrayList<String> redirectValue = new ArrayList<String>();
            redirectValue.add(redirectUrl);
            headers.put("redirect-uri", redirectValue);
        }
        if (this.codeVerifier != null) {
            headers.put("code-verifier", Collections.singletonList(this.codeVerifier));
        }
        return headers;
    }

    @Override
    public List<Pair<String, String>> getParams() {
        String redirectUrl;
        ArrayList<Pair<String, String>> params = new ArrayList<Pair<String, String>>();
        params.add(new Pair((Object)"code", (Object)this.code));
        if (this.codeVerifier != null) {
            params.add(new Pair((Object)"code_verifier", (Object)this.codeVerifier));
        }
        if ((redirectUrl = (String)ConfigurationManager.getInstance().getConnectedGatewayConfigurationProvider().getProperty("msso.authorize.redirect.uri")) != null) {
            params.add((Pair<String, String>)new Pair((Object)"redirect_uri", (Object)redirectUrl));
        }
        return params;
    }

    @Override
    public String getGrantType() {
        return "authorization_code";
    }

    @Override
    public String getUsername() {
        return "socialLogin";
    }

    @Override
    public boolean isReusable() {
        return false;
    }

    @Override
    public boolean canRegisterDevice() {
        return true;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(this.code);
        dest.writeString(this.state);
        dest.writeString(this.codeVerifier);
    }

    protected MASAuthCredentialsAuthorizationCode(Parcel in) {
        this.code = in.readString();
        this.state = in.readString();
        this.codeVerifier = in.readString();
    }
}

