/*
 * Decompiled with CFR 0.152.
 */
package com.ca.mas.foundation;

import android.net.Uri;
import com.ca.mas.core.client.ServerClient;
import com.ca.mas.core.conf.ConfigurationManager;
import com.ca.mas.core.error.TargetApiException;
import com.ca.mas.foundation.MAS;
import com.ca.mas.foundation.MASCallback;
import com.ca.mas.foundation.MASDeviceAttributeOverflowException;
import com.ca.mas.foundation.MASException;
import com.ca.mas.foundation.MASRequest;
import com.ca.mas.foundation.MASRequestBody;
import com.ca.mas.foundation.MASResponse;
import com.ca.mas.foundation.MASResponseBody;
import com.ca.mas.foundation.notify.Callback;
import java.net.URI;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

class DeviceMetadata {
    private static final int MAG_MAX_METADATA = 1016155;
    private static final int MAG_ATTR_NOT_FOUND = 1016156;

    private DeviceMetadata() {
        throw new IllegalStateException("Not allowed to instantiate");
    }

    private static URI getPath() {
        return ConfigurationManager.getInstance().getConnectedGatewayConfigurationProvider().getTokenUri("msso_device_metadata");
    }

    public static void putAttribute(String attr, String value, final MASCallback<Void> callback) {
        DeviceMetadata.checkConditions(attr);
        MASRequest request = null;
        try {
            JSONObject data = new JSONObject();
            data.put("name", (Object)attr);
            data.put("value", (Object)value);
            request = new MASRequest.MASRequestBuilder(DeviceMetadata.getPath()).put(MASRequestBody.jsonBody(data)).notifyOnCancel().build();
        }
        catch (JSONException e) {
            Callback.onError(callback, e);
            return;
        }
        MAS.invoke(request, new MASCallback<MASResponse<JSONObject>>(){

            @Override
            public void onSuccess(MASResponse<JSONObject> response) {
                Callback.onSuccess(callback, null);
            }

            @Override
            public void onError(Throwable e) {
                int errorCode = DeviceMetadata.getSpecialError(e);
                if (errorCode == 1016155) {
                    Callback.onError(callback, new MASDeviceAttributeOverflowException(e));
                } else {
                    Callback.onError(callback, e);
                }
            }
        });
    }

    private static int getSpecialError(Throwable e) {
        int error = -1;
        try {
            if (((MASException)e).getRootCause() instanceof TargetApiException) {
                TargetApiException tException = (TargetApiException)((MASException)e).getRootCause();
                error = ServerClient.findErrorCode(tException.getResponse());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return error;
    }

    public static void getAttribute(String name, final MASCallback<JSONObject> callback) {
        DeviceMetadata.checkConditions(name);
        Uri route = Uri.parse((String)DeviceMetadata.getPath().toString()).buildUpon().appendPath(name).build();
        MASRequest request = null;
        request = new MASRequest.MASRequestBuilder(route).responseBody(MASResponseBody.jsonBody()).get().notifyOnCancel().build();
        MAS.invoke(request, new MASCallback<MASResponse<JSONObject>>(){

            @Override
            public void onSuccess(MASResponse<JSONObject> response) {
                Callback.onSuccess(callback, response.getBody().getContent());
            }

            @Override
            public void onError(Throwable e) {
                int errorCode = DeviceMetadata.getSpecialError(e);
                if (errorCode == 1016156) {
                    Callback.onSuccess(callback, new JSONObject());
                } else {
                    Callback.onError(callback, e);
                }
            }
        });
    }

    public static void getAttributes(final MASCallback<JSONArray> callback) {
        MASRequest request = null;
        request = new MASRequest.MASRequestBuilder(DeviceMetadata.getPath()).get().notifyOnCancel().build();
        MAS.invoke(request, new MASCallback<MASResponse<JSONArray>>(){

            @Override
            public void onSuccess(MASResponse<JSONArray> response) {
                Callback.onSuccess(callback, response.getBody().getContent());
            }

            @Override
            public void onError(Throwable e) {
                Callback.onError(callback, e);
            }
        });
    }

    public static void deleteAttribute(String name, final MASCallback<Void> callback) {
        DeviceMetadata.checkConditions(name);
        MASRequest request = null;
        Uri route = Uri.parse((String)DeviceMetadata.getPath().toString()).buildUpon().appendPath(name).build();
        request = new MASRequest.MASRequestBuilder(route).delete(MASRequestBody.stringBody(name)).notifyOnCancel().build();
        MAS.invoke(request, new MASCallback<MASResponse<String>>(){

            @Override
            public void onSuccess(MASResponse<String> response) {
                Callback.onSuccess(callback, null);
            }

            @Override
            public void onError(Throwable e) {
                int errorCode = DeviceMetadata.getSpecialError(e);
                if (errorCode == 1016156) {
                    Callback.onSuccess(callback, null);
                } else {
                    Callback.onError(callback, e);
                }
            }
        });
    }

    public static void deleteAttributes(final MASCallback<Void> callback) {
        MASRequest request = null;
        request = new MASRequest.MASRequestBuilder(DeviceMetadata.getPath()).delete(MASRequestBody.stringBody("")).notifyOnCancel().build();
        MAS.invoke(request, new MASCallback<MASResponse<String>>(){

            @Override
            public void onSuccess(MASResponse<String> response) {
                Callback.onSuccess(callback, null);
            }

            @Override
            public void onError(Throwable e) {
                Callback.onError(callback, e);
            }
        });
    }

    private static void checkConditions(String name) {
        if (name == null) {
            throw new IllegalArgumentException("Attribute name cannot be null");
        }
    }
}

