/*
 * Decompiled with CFR 0.152.
 */
package com.ca.mas.foundation;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Parcelable;
import android.util.Log;
import com.ca.mas.core.MobileSsoListener;
import com.ca.mas.core.service.AuthenticationProvider;
import com.ca.mas.foundation.MAS;
import com.ca.mas.foundation.MASAuthenticationListener;
import com.ca.mas.foundation.MASAuthorizationRequest;
import com.ca.mas.foundation.MASAuthorizationRequestHandler;
import com.ca.mas.foundation.MASOtpAuthenticationHandler;
import com.ca.mas.foundation.MASUser;
import com.ca.mas.foundation.auth.MASAuthenticationProviders;
import java.lang.reflect.Constructor;

class AuthenticationListener
implements MobileSsoListener {
    private Context mAppContext;

    AuthenticationListener(Context context) {
        this.mAppContext = context;
    }

    @Override
    public void onAuthenticateRequest(long requestId, AuthenticationProvider provider) {
        if (MAS.getAuthenticationListener() == null) {
            Class<Activity> loginActivity;
            if (MAS.isBrowserBasedAuthenticationEnabled()) {
                MASAuthorizationRequest authReq = new MASAuthorizationRequest.MASAuthorizationRequestBuilder().buildDefault();
                MASAuthorizationRequestHandler handler = this.getAuthorizationRequestHandler();
                if (handler != null) {
                    MASUser.login(authReq, handler);
                    return;
                }
            }
            if ((loginActivity = this.getLoginActivity()) != null) {
                if (this.mAppContext != null) {
                    Intent intent = new Intent(this.mAppContext, loginActivity);
                    intent.addFlags(0x10000000);
                    intent.putExtra("com.ca.mas.core.service.req.extra.requestId", requestId);
                    intent.putExtra("com.ca.mas.core.service.req.extra.social.login.providers", (Parcelable)new MASAuthenticationProviders(provider));
                    this.mAppContext.startActivity(intent);
                }
            } else if (MAS.DEBUG) {
                Log.w((String)"MAS", (String)(MASAuthenticationListener.class.getSimpleName() + " is required for user authentication."));
            }
        } else {
            MAS.getAuthenticationListener().onAuthenticateRequest((Context)MAS.getCurrentActivity(), requestId, new MASAuthenticationProviders(provider));
        }
    }

    @Override
    public void onOtpAuthenticationRequest(MASOtpAuthenticationHandler otpAuthenticationHandler) {
    }

    private Class<Activity> getLoginActivity() {
        try {
            return Class.forName("com.ca.mas.ui.MASLoginActivity");
        }
        catch (Exception e) {
            return null;
        }
    }

    private MASAuthorizationRequestHandler getAuthorizationRequestHandler() {
        try {
            Class<?> c = Class.forName("com.ca.mas.ui.MASAppAuthAuthorizationRequestHandler");
            Constructor<?> constructor = c.getConstructor(Context.class);
            return (MASAuthorizationRequestHandler)constructor.newInstance(MAS.getCurrentActivity());
        }
        catch (Exception e) {
            return null;
        }
    }
}

