/*
 * Decompiled with CFR 0.152.
 */
package com.ca.mas.core.storage.implementation;

import android.util.Log;
import com.ca.mas.core.storage.Storage;
import com.ca.mas.core.storage.StorageException;
import com.ca.mas.core.storage.implementation.AccountManagerStorage;
import com.ca.mas.core.storage.implementation.KeyStoreStorage;
import com.ca.mas.foundation.MAS;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;

public class MASStorageManager {
    public Storage getStorage(String className, Object options) throws StorageException {
        try {
            return this.getStorage(Class.forName(className), options);
        }
        catch (ClassNotFoundException e) {
            String msg = "Error instantiating the requested Storage - " + className + " reason: " + e;
            if (MAS.DEBUG) {
                Log.e((String)"MAS", (String)msg);
            }
            throw new StorageException(msg, null, 108);
        }
    }

    public Storage getStorage(Class<? extends Storage> c, Object options) throws StorageException {
        try {
            Constructor<?>[] allConstructors = c.getDeclaredConstructors();
            if (allConstructors != null && allConstructors.length > 0) {
                Constructor<?> constructor = allConstructors[0];
                constructor.setAccessible(true);
                return (Storage)constructor.newInstance(options);
            }
            throw new Exception("No constructors found");
        }
        catch (InvocationTargetException in) {
            String msg = "Error instantiating the requested Storage - " + c.getCanonicalName() + " reason: " + in;
            if (MAS.DEBUG) {
                Log.e((String)"MAS", (String)msg);
            }
            throw (StorageException)in.getTargetException();
        }
        catch (Exception e) {
            String msg = "Error instantiating the requested Storage - " + c.getName() + " reason: " + e;
            if (MAS.DEBUG) {
                Log.e((String)"MAS", (String)msg);
            }
            throw new StorageException(msg, null, 108);
        }
    }

    public Storage getStorage(MASStorageType type, Object options) throws StorageException {
        if (type == null) {
            throw new StorageException(108);
        }
        return this.getStorage(type.getClassName(), options);
    }

    public static enum MASStorageType {
        TYPE_KEYSTORE(KeyStoreStorage.class),
        TYPE_AMS(AccountManagerStorage.class);

        private final Class<? extends Storage> className;

        private MASStorageType(Class<? extends Storage> className) {
            this.className = className;
        }

        private Class<? extends Storage> getClassName() {
            return this.className;
        }
    }
}

