/*
 * Decompiled with CFR 0.152.
 */
package com.ca.mas.core.storage.implementation;

import android.accounts.Account;
import android.accounts.AccountManager;
import android.content.ComponentName;
import android.content.Context;
import android.content.pm.PackageManager;
import android.content.res.XmlResourceParser;
import android.os.Bundle;
import android.util.Log;
import com.ca.mas.core.storage.StorageException;
import com.ca.mas.core.storage.implementation.AMSAuthenticatorService;
import com.ca.mas.foundation.MAS;
import java.io.IOException;
import org.xmlpull.v1.XmlPullParserException;

class AMSSManager {
    private static final String ACCOUNT_NAME = "account.name";
    private static AMSSManager ourInstance;
    private static final String CA_MAS = "CA MAS";
    private String mAccountName = "CA MAS";
    private String mAccountType;
    private Account mAccount;
    private Object mutex = new Object();
    private Context mContext;

    public static AMSSManager getInstance(Context ctx) throws StorageException {
        if (ourInstance == null) {
            ourInstance = new AMSSManager(ctx.getApplicationContext());
        }
        return ourInstance;
    }

    private AMSSManager(Context ctx) throws StorageException {
        this.mContext = ctx;
        this.mAccountType = this.getAccountType();
        this.mAccountName = this.getAccountName();
        if (this.mAccountType == null) {
            if (MAS.DEBUG) {
                Log.e((String)"MAS", (String)"Missing/malformed android.accounts.AccountAuthenticator xml file in application resource.");
            }
            throw new StorageException("Missing/malformed android.accounts.AccountAuthenticator xml file in application resource.", null, 111);
        }
        if (!this.addAccount(this.mAccountName, this.mAccountType)) {
            throw new StorageException(106);
        }
    }

    private String getAccountName() {
        ComponentName myService = new ComponentName(this.mContext, AMSAuthenticatorService.class);
        try {
            Bundle data = this.mContext.getPackageManager().getServiceInfo((ComponentName)myService, (int)128).metaData;
            int resourceId = data.getInt(ACCOUNT_NAME);
            if (resourceId != 0) {
                return this.mContext.getResources().getString(resourceId);
            }
            return data.getString(ACCOUNT_NAME, CA_MAS);
        }
        catch (PackageManager.NameNotFoundException e) {
            if (MAS.DEBUG) {
                Log.d((String)"MAS", (String)String.format("Account name is not provided, use %S", CA_MAS));
            }
            return CA_MAS;
        }
    }

    private String getAccountType() {
        block6: {
            ComponentName myService = new ComponentName(this.mContext, AMSAuthenticatorService.class);
            try {
                Bundle data = this.mContext.getPackageManager().getServiceInfo((ComponentName)myService, (int)128).metaData;
                int resourceId = data.getInt("android.accounts.AccountAuthenticator");
                XmlResourceParser xrp = this.mContext.getResources().getXml(resourceId);
                while (xrp.getEventType() != 1) {
                    String s;
                    if (xrp.getEventType() == 2 && (s = xrp.getName()).equals("account-authenticator")) {
                        return xrp.getAttributeValue("http://schemas.android.com/apk/res/android", "accountType");
                    }
                    xrp.next();
                }
            }
            catch (PackageManager.NameNotFoundException e) {
                if (MAS.DEBUG) {
                    Log.e((String)"MAS", (String)("Missing android.accounts.AccountAuthenticator metadata for " + AMSAuthenticatorService.class.getCanonicalName()));
                }
            }
            catch (IOException | XmlPullParserException e) {
                if (!MAS.DEBUG) break block6;
                Log.e((String)"MAS", (String)"Failed to retrieve account type", (Throwable)e);
            }
        }
        return null;
    }

    private boolean addAccount(String accountName, String accountType) throws StorageException {
        AccountManager am = AccountManager.get((Context)this.mContext);
        if (!this.isAccountPresent(accountName, accountType)) {
            Account account = new Account(accountName, accountType);
            return am.addAccountExplicitly(account, this.getPassword(), null);
        }
        if (MAS.DEBUG) {
            Log.i((String)"MAS", (String)"Account already present");
        }
        try {
            String password = am.getPassword(this.getAccount());
            if (password != null && !this.getPassword().equals(password)) {
                throw new StorageException("Can't access Account", null, 115);
            }
        }
        catch (Exception e) {
            throw new StorageException("Can't access Account", e, 115);
        }
        return true;
    }

    private boolean isAccountPresent(String accountName, String accountType) {
        AccountManager am = AccountManager.get((Context)this.mContext);
        Account[] existingAccounts = am.getAccountsByType(accountType);
        if (existingAccounts.length == 0) {
            return false;
        }
        for (Account acc : existingAccounts) {
            if (!accountName.equals(acc.name)) continue;
            return true;
        }
        return false;
    }

    private String getPassword() {
        String packageName = this.mContext.getPackageName();
        String sharedUserId = null;
        try {
            sharedUserId = this.mContext.getPackageManager().getPackageInfo((String)packageName, (int)0).sharedUserId;
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            // empty catch block
        }
        return sharedUserId != null ? sharedUserId : packageName;
    }

    Account getAccount() throws Exception {
        if (this.mAccount == null) {
            Object object = this.mutex;
            synchronized (object) {
                if (this.mAccount != null) {
                    return this.mAccount;
                }
                AccountManager am = AccountManager.get((Context)this.mContext);
                for (Account a : am.getAccountsByType(this.mAccountType)) {
                    if (!a.name.equals(this.mAccountName)) continue;
                    this.mAccount = a;
                    return this.mAccount;
                }
                if (MAS.DEBUG) {
                    Log.e((String)"MAS", (String)String.format("Account of type %s, name %s doesn't exist ", this.mAccountType, this.mAccountName));
                }
                throw new Exception(String.format("Account of type %s, name %s doesn't exist ", this.mAccountType, this.mAccountName));
            }
        }
        return this.mAccount;
    }

    public void reset() {
        ourInstance = null;
    }
}

