/*
 * Decompiled with CFR 0.152.
 */
package com.ca.mas.core.storage;

import android.os.Parcel;
import android.os.Parcelable;
import java.io.Serializable;

public class StorageResult
implements Parcelable {
    public static final Parcelable.Creator CREATOR = new Parcelable.Creator(){

        public StorageResult createFromParcel(Parcel in) {
            return new StorageResult(in);
        }

        public StorageResult[] newArray(int size) {
            return new StorageResult[size];
        }
    };
    private StorageOperationStatus status = StorageOperationStatus.SUCCESS;
    private Object data;
    private StorageOperationType type;

    public StorageResult(StorageOperationType type) {
        this.type = type;
    }

    private StorageResult(Parcel input) {
        this.type = (StorageOperationType)((Object)input.readSerializable());
        this.status = (StorageOperationStatus)((Object)input.readSerializable());
        this.data = input.readArray(this.getClass().getClassLoader())[0];
    }

    public StorageOperationType getType() {
        return this.type;
    }

    public void setType(StorageOperationType type) {
        this.type = type;
    }

    public StorageOperationStatus getStatus() {
        return this.status;
    }

    public void setStatus(StorageOperationStatus status) {
        this.status = status;
    }

    public Object getData() {
        return this.data;
    }

    public void setData(Object data) {
        this.data = data;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeSerializable((Serializable)((Object)this.getType()));
        dest.writeSerializable((Serializable)((Object)this.getStatus()));
        dest.writeArray(new Object[]{this.data});
    }

    public static enum StorageOperationType {
        WRITE(0),
        WRITE_STRING(1),
        READ(2),
        READ_STRING(3),
        UPDATE(4),
        UPDATE_STRING(5),
        DELETE(6),
        DELETE_STRING(7),
        DELETE_ALL(8),
        WRITE_OR_UPDATE(9),
        WRITE_OR_UPDATE_STRING(10),
        GET_ALL_KEYS(11);

        private int value;

        private StorageOperationType(int value) {
            this.value = value;
        }
    }

    public static enum StorageOperationStatus {
        SUCCESS(0),
        FAILURE(1);

        private int value;

        private StorageOperationStatus(int value) {
            this.value = value;
        }
    }
}

