/*
 * Decompiled with CFR 0.152.
 */
package com.ca.mas.core.security;

import android.content.Context;
import android.support.annotation.NonNull;
import android.support.annotation.RequiresApi;
import android.util.Log;
import com.ca.mas.core.security.EncryptionProvider;
import com.ca.mas.core.security.KeyStorageProvider;
import com.ca.mas.core.security.SharedPreferencesKeyStorageProvider;
import com.ca.mas.core.util.KeyUtilsSymmetric;
import com.ca.mas.foundation.MAS;
import javax.crypto.SecretKey;
import javax.security.auth.DestroyFailedException;
import javax.security.auth.Destroyable;

public class DefaultEncryptionProvider
implements EncryptionProvider {
    private KeyStorageProvider ksp;
    private static final String KEY_ALIAS = "secret";

    public DefaultEncryptionProvider(@NonNull Context ctx) {
        this(ctx, new SharedPreferencesKeyStorageProvider(ctx));
    }

    public DefaultEncryptionProvider(Context ctx, KeyStorageProvider keyStorageProvider) {
        this.ksp = keyStorageProvider;
    }

    protected String getKeyAlias() {
        return KEY_ALIAS;
    }

    @Override
    public byte[] encrypt(byte[] data) {
        byte[] encryptedData;
        if (data == null) {
            return null;
        }
        try {
            SecretKey secretKey = this.ksp.getKey(this.getKeyAlias(), false);
            encryptedData = KeyUtilsSymmetric.encrypt(data, secretKey, this.getKeyAlias());
        }
        catch (Exception e) {
            if (MAS.DEBUG) {
                Log.e((String)"MAS", (String)"inside exception of encrypt function: ", (Throwable)e);
            }
            throw new RuntimeException(e.getMessage(), e);
        }
        return encryptedData;
    }

    @Override
    public byte[] decrypt(byte[] encryptedData) {
        try {
            SecretKey secretKey = this.ksp.getKey(this.getKeyAlias(), false);
            return KeyUtilsSymmetric.decrypt(encryptedData, secretKey, this.getKeyAlias());
        }
        catch (Exception e) {
            if (MAS.DEBUG) {
                Log.i((String)"MAS", (String)"Error while decrypting an cipher instance", (Throwable)e);
            }
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    @RequiresApi(api=26)
    private void destroyKey(SecretKey key) {
        block3: {
            if (key instanceof Destroyable) {
                SecretKey destroyable = key;
                try {
                    destroyable.destroy();
                }
                catch (DestroyFailedException e) {
                    if (!MAS.DEBUG) break block3;
                    Log.e((String)"MAS", (String)"Could not destroy key");
                }
            }
        }
    }
}

