/*
 * Decompiled with CFR 0.152.
 */
package com.ca.mas.core.security;

import android.content.Context;
import android.support.annotation.NonNull;
import android.util.Log;
import com.ca.mas.core.datasource.AccountManagerStoreDataSource;
import com.ca.mas.core.datasource.DataSource;
import com.ca.mas.core.datasource.DataSourceFactory;
import com.ca.mas.core.security.KeyStoreKeyStorageProvider;
import com.ca.mas.foundation.MAS;
import org.json.JSONException;
import org.json.JSONObject;

public class AccountManagerKeyStorageProvider
extends KeyStoreKeyStorageProvider {
    private DataSource<String, byte[]> storage;

    public AccountManagerKeyStorageProvider(@NonNull Context ctx) {
        JSONObject params;
        block2: {
            super(ctx);
            params = new JSONObject();
            try {
                params.put("share", (Object)Boolean.TRUE);
            }
            catch (JSONException e) {
                if (!MAS.DEBUG) break block2;
                Log.w((String)"MAS", (String)("Failed to set sharing property " + (Object)((Object)e)));
            }
        }
        this.storage = DataSourceFactory.getStorage(ctx, AccountManagerStoreDataSource.class, params, null);
    }

    @Override
    protected boolean storeSecretKeyLocally(String alias, byte[] encryptedSecretkey) {
        this.storage.put(alias, encryptedSecretkey);
        return true;
    }

    @Override
    protected byte[] getEncryptedSecretKey(String alias) {
        byte[] encryptedSecretKey = this.storage.get(alias);
        return encryptedSecretKey;
    }

    @Override
    protected boolean deleteSecretKeyLocally(String alias) {
        this.storage.remove(alias);
        return true;
    }
}

