/*
 * Decompiled with CFR 0.152.
 */
package com.ca.mas.core.cert;

import android.util.Base64;
import com.ca.mas.core.io.IoUtils;
import java.io.Serializable;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.regex.Pattern;

public class PublicKeyHash
implements Serializable {
    private static final Pattern SHA256_HEX_PATTERN = Pattern.compile("[a-f0-9]{64}");
    private final byte[] hash;

    private PublicKeyHash(byte[] hash) {
        this.hash = hash;
    }

    public static PublicKeyHash fromPublicKey(PublicKey publicKey) {
        return new PublicKeyHash(PublicKeyHash.toHash(publicKey));
    }

    public static PublicKeyHash fromCertificate(Certificate certificate) {
        return PublicKeyHash.fromPublicKey(certificate.getPublicKey());
    }

    public static PublicKeyHash fromHashString(String hashString, int flags) {
        if (SHA256_HEX_PATTERN.matcher(hashString).matches()) {
            return new PublicKeyHash(IoUtils.hexToByteArray(hashString));
        }
        return new PublicKeyHash(Base64.decode((String)hashString, (int)flags));
    }

    public boolean matches(byte[] otherHash) {
        return this.hash != null && Arrays.equals(this.hash, otherHash);
    }

    public boolean matches(PublicKey publicKey) {
        return this.matches(PublicKeyHash.toHash(publicKey));
    }

    public boolean matches(X509Certificate certificate) {
        return this.matches(certificate.getPublicKey());
    }

    public String getHashString() {
        return Base64.encodeToString((byte[])this.hash, (int)2);
    }

    private static byte[] toHash(PublicKey publicKey) {
        byte[] encoded = publicKey.getEncoded();
        if (encoded == null || encoded.length < 1) {
            throw new IllegalArgumentException("public key cannot be encoded");
        }
        String format = publicKey.getFormat();
        if (!"X.509".equalsIgnoreCase(format) && !"x509".equalsIgnoreCase(format)) {
            throw new IllegalArgumentException("public key encoding format is not X.509");
        }
        try {
            MessageDigest md = MessageDigest.getInstance("SHA-256");
            md.update(encoded);
            return md.digest();
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PublicKeyHash that = (PublicKeyHash)o;
        return Arrays.equals(this.hash, that.hash);
    }

    public int hashCode() {
        return Arrays.hashCode(this.hash);
    }
}

