/*
 * Decompiled with CFR 0.152.
 */
package com.ca.mas.identity.user;

import android.graphics.Bitmap;
import android.support.annotation.NonNull;
import com.ca.mas.foundation.MASCallback;
import com.ca.mas.foundation.MASGroup;
import com.ca.mas.foundation.MASSessionUnlockCallback;
import com.ca.mas.foundation.MASTransformable;
import com.ca.mas.foundation.MASUser;
import com.ca.mas.identity.common.MASFilteredRequest;
import com.ca.mas.identity.user.MASAddress;
import com.ca.mas.identity.user.MASEmail;
import com.ca.mas.identity.user.MASIms;
import com.ca.mas.identity.user.MASMeta;
import com.ca.mas.identity.user.MASName;
import com.ca.mas.identity.user.MASPhone;
import com.ca.mas.identity.user.MASPhoto;
import com.ca.mas.identity.user.UserAttributes;
import com.ca.mas.identity.user.UserNotAuthenticatedException;
import com.ca.mas.identity.util.IdentityUtil;
import com.ca.mas.messaging.MASMessage;
import com.ca.mas.messaging.topic.MASTopic;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class User
extends MASUser {
    protected String mId;
    private String mExternalId;
    protected MASName mName;
    protected String mUserName;
    private String mNickName;
    private String mDisplayName;
    private String mProfileUrl;
    private String mUserType;
    private String mTitle;
    private String mPreferredLanguage;
    private String mLocale;
    private String mTimeZone;
    private boolean mIsActive;
    private String mPassword;
    private MASMeta mMeta;
    private long mCardinality;
    private JSONObject mSource;
    private final List<MASAddress> mAddressList = new ArrayList<MASAddress>();
    private final List<MASEmail> mEmailList = new ArrayList<MASEmail>();
    private final List<MASPhone> mPhoneList = new ArrayList<MASPhone>();
    private final List<MASPhoto> mPhotoList;
    private final List<MASIms> mImsList = new ArrayList<MASIms>();
    private final List<X509Cert> mCertList;
    private final List<MASGroup> mGroupList;

    public User() {
        this.mPhotoList = new ArrayList<MASPhoto>();
        this.mCertList = new ArrayList<X509Cert>();
        this.mGroupList = new ArrayList<MASGroup>();
    }

    @Override
    public void populate(@NonNull JSONObject jsonObject) throws JSONException {
        JSONArray groupArr;
        JSONArray certsArr;
        JSONArray photosArr;
        JSONArray imsArr;
        JSONArray phoneArr;
        JSONArray emailArr;
        int i;
        JSONArray addrArr;
        this.mSource = jsonObject;
        if (jsonObject.has("sub")) {
            String phone;
            String email;
            this.mId = this.mUserName = jsonObject.optString("preferred_username", "");
            final String photo = jsonObject.optString("picture", null);
            if (photo != null) {
                this.mPhotoList.add(new MASPhoto(){

                    @Override
                    public String getValue() {
                        return photo;
                    }
                });
            }
            if ((email = jsonObject.optString("email", null)) != null) {
                this.mEmailList.add(new MASEmail(){

                    @Override
                    public String getValue() {
                        return email;
                    }
                });
            }
            if ((phone = jsonObject.optString("phone_number", null)) != null) {
                this.mPhoneList.add(new MASPhone(){

                    @Override
                    public String getValue() {
                        return phone;
                    }
                });
            }
            final String givenName = jsonObject.optString("given_name", null);
            final String familyName = jsonObject.optString("family_name", null);
            final String middleName = jsonObject.optString("middle_name", null);
            this.mName = new MASName(){

                @Override
                public String getGivenName() {
                    return givenName;
                }

                @Override
                public String getFamilyName() {
                    return familyName;
                }

                @Override
                public String getMiddleName() {
                    return middleName;
                }
            };
            JSONObject addrObj = jsonObject.optJSONObject("address");
            if (addrObj != null) {
                String streetAddr = addrObj.optString("street_address", "");
                String locality = addrObj.optString("locality", "");
                String region = addrObj.optString("region", "");
                String postalCode = addrObj.optString("postal_code", "");
                String country = addrObj.optString("country", "");
                MASAddress address = new MASAddress(streetAddr, locality, region, country, postalCode);
                this.mAddressList.add(address);
            }
            return;
        }
        this.mId = jsonObject.optString("id");
        this.mExternalId = jsonObject.optString("externalId");
        this.mUserName = jsonObject.optString("userName");
        this.mDisplayName = jsonObject.optString("displayName");
        this.mNickName = jsonObject.optString("nickName");
        this.mProfileUrl = jsonObject.optString("profileUrl");
        this.mUserType = jsonObject.optString("userType");
        this.mTitle = jsonObject.optString("title");
        this.mPreferredLanguage = jsonObject.optString("preferredLanguage");
        this.mLocale = jsonObject.optString("locale");
        this.mTimeZone = jsonObject.optString("timezone");
        this.mPassword = jsonObject.optString("password");
        this.mIsActive = jsonObject.optBoolean("active", false);
        if (jsonObject.has("meta")) {
            JSONObject metaObj = jsonObject.getJSONObject("meta");
            this.mMeta = new MASMeta();
            this.mMeta.populate(metaObj);
        }
        if (jsonObject.has("name")) {
            JSONObject nameObj = jsonObject.getJSONObject("name");
            this.mName = new MASName();
            this.mName.populate(nameObj);
        }
        if (jsonObject.has("addresses") && (addrArr = jsonObject.getJSONArray("addresses")) != null) {
            for (i = 0; i < addrArr.length(); ++i) {
                JSONObject addrObj = addrArr.getJSONObject(i);
                MASAddress address = new MASAddress();
                address.populate(addrObj);
                this.mAddressList.add(address);
            }
        }
        if (jsonObject.has("emails") && (emailArr = jsonObject.getJSONArray("emails")) != null) {
            for (i = 0; i < emailArr.length(); ++i) {
                JSONObject emailObj = emailArr.getJSONObject(i);
                MASEmail email = new MASEmail();
                email.populate(emailObj);
                this.mEmailList.add(email);
            }
        }
        if (jsonObject.has("phoneNumbers") && (phoneArr = jsonObject.getJSONArray("phoneNumbers")) != null) {
            for (i = 0; i < phoneArr.length(); ++i) {
                JSONObject phoneObj = phoneArr.getJSONObject(i);
                MASPhone phone = new MASPhone();
                phone.populate(phoneObj);
                this.mPhoneList.add(phone);
            }
        }
        if (jsonObject.has("ims") && (imsArr = jsonObject.getJSONArray("ims")) != null) {
            for (i = 0; i < imsArr.length(); ++i) {
                JSONObject imsObj = imsArr.getJSONObject(i);
                MASIms ims = new MASIms();
                ims.populate(imsObj);
                this.mImsList.add(ims);
            }
        }
        if (jsonObject.has("photos") && (photosArr = jsonObject.getJSONArray("photos")) != null) {
            for (i = 0; i < photosArr.length(); ++i) {
                JSONObject photoObj = photosArr.getJSONObject(i);
                MASPhoto photo = new MASPhoto();
                photo.populate(photoObj);
                this.mPhotoList.add(photo);
            }
        }
        if (jsonObject.has("x509Certificates") && (certsArr = jsonObject.getJSONArray("x509Certificates")) != null) {
            for (i = 0; i < certsArr.length(); ++i) {
                JSONObject certObj = certsArr.getJSONObject(i);
                X509Cert x509Cert = new X509Cert();
                x509Cert.populate(certObj);
                this.mCertList.add(x509Cert);
            }
        }
        if (jsonObject.has("groups") && (groupArr = jsonObject.getJSONArray("groups")) != null) {
            for (i = 0; i < groupArr.length(); ++i) {
                JSONObject groupObj = groupArr.getJSONObject(i);
                MASGroup group = MASGroup.newInstance();
                group.populate(groupObj);
                this.mGroupList.add(group);
            }
        }
    }

    @Override
    public JSONObject getAsJSONObject() throws JSONException {
        return this.mSource;
    }

    @Override
    public String getId() {
        return this.mId;
    }

    @Override
    public String getExternalId() {
        return this.mExternalId;
    }

    @Override
    public String getDisplayName() {
        return this.mDisplayName;
    }

    @Override
    public long getCardinality() {
        return this.mCardinality;
    }

    @Override
    public List<MASAddress> getAddressList() {
        return this.mAddressList;
    }

    @Override
    public List<MASEmail> getEmailList() {
        return this.mEmailList;
    }

    @Override
    public List<MASPhone> getPhoneList() {
        return this.mPhoneList;
    }

    @Override
    public List<MASIms> getImsList() {
        return this.mImsList;
    }

    @Override
    public List<MASPhoto> getPhotoList() {
        return this.mPhotoList;
    }

    @Override
    public String getNickName() {
        return this.mNickName;
    }

    @Override
    public String getProfileUrl() {
        return this.mProfileUrl;
    }

    @Override
    public String getUserName() {
        return this.mUserName;
    }

    @Override
    public String getUserType() {
        return this.mUserType;
    }

    @Override
    public String getTitle() {
        return this.mTitle;
    }

    @Override
    public String getPreferredLanguage() {
        return this.mPreferredLanguage;
    }

    @Override
    public String getLocale() {
        return this.mLocale;
    }

    @Override
    public String getTimeZone() {
        return this.mTimeZone;
    }

    @Override
    public boolean isActive() {
        return this.mIsActive;
    }

    @Override
    public String getPassword() {
        return this.mPassword;
    }

    @Override
    public MASMeta getMeta() {
        return this.mMeta;
    }

    @Override
    public List<MASGroup> getGroupList() {
        return this.mGroupList;
    }

    @Override
    public void getUserById(String id, MASCallback<MASUser> callback) {
        throw new UserNotAuthenticatedException();
    }

    @Override
    public void getUsersByFilter(MASFilteredRequest filteredRequest, MASCallback<List<MASUser>> callback) {
        throw new UserNotAuthenticatedException();
    }

    @Override
    public void getUserMetaData(MASCallback<UserAttributes> callback) {
        throw new UserNotAuthenticatedException();
    }

    @Override
    public String getAccessToken() {
        throw new UserNotAuthenticatedException();
    }

    @Override
    public Bitmap getThumbnailImage() {
        return IdentityUtil.getThumbnail(this.getPhotoList());
    }

    @Override
    public void sendMessage(MASTopic topic, MASMessage message, MASCallback<Void> callback) {
        throw new UserNotAuthenticatedException();
    }

    @Override
    public void sendMessage(MASMessage message, MASUser user, MASCallback<Void> callback) {
        throw new UserNotAuthenticatedException();
    }

    @Override
    public void sendMessage(MASMessage message, MASUser user, String topic, MASCallback<Void> callback) {
        throw new UserNotAuthenticatedException();
    }

    @Override
    public void sendMessage(MASMessage message, MASGroup group, MASCallback<Void> callback) {
        throw new UserNotAuthenticatedException();
    }

    @Override
    public void sendMessage(MASMessage message, MASGroup group, String topic, MASCallback<Void> callback) {
        throw new UserNotAuthenticatedException();
    }

    @Override
    public void startListeningToMyMessages(MASCallback<Void> callback) {
        throw new UserNotAuthenticatedException();
    }

    @Override
    public void stopListeningToMyMessages(MASCallback<Void> callback) {
        throw new UserNotAuthenticatedException();
    }

    @Override
    @Deprecated
    public void logout(MASCallback<Void> callback) {
        throw new UserNotAuthenticatedException();
    }

    @Override
    public void logout(boolean force, MASCallback<Void> callback) {
        throw new UserNotAuthenticatedException();
    }

    @Override
    public boolean isAuthenticated() {
        return false;
    }

    @Override
    public boolean isCurrentUser() {
        return false;
    }

    @Override
    public void requestUserInfo(MASCallback<Void> callback) {
        throw new UserNotAuthenticatedException();
    }

    @Override
    public void lockSession(MASCallback<Void> callback) {
        throw new UserNotAuthenticatedException();
    }

    @Override
    public void unlockSession(MASSessionUnlockCallback<Void> callback) {
        throw new UserNotAuthenticatedException();
    }

    @Override
    public boolean isSessionLocked() {
        return false;
    }

    @Override
    public void removeSessionLock(MASCallback<Void> callback) {
        throw new UserNotAuthenticatedException();
    }

    @Override
    public MASName getName() {
        return this.mName;
    }

    @Override
    public JSONObject getSource() {
        return this.mSource;
    }

    public class X509Cert
    implements MASTransformable {
        private String mValue;

        @Override
        public void populate(@NonNull JSONObject jobj) throws JSONException {
            this.mValue = jobj.optString("value");
        }

        @Override
        public JSONObject getAsJSONObject() throws JSONException {
            JSONObject jobj = new JSONObject();
            jobj.put("value", (Object)this.mValue);
            return jobj;
        }
    }
}

