/*
 * Decompiled with CFR 0.152.
 */
package com.ca.mas.foundation.auth;

import android.app.Activity;
import android.content.Context;
import android.os.Bundle;
import com.ca.mas.core.MAGResultReceiver;
import com.ca.mas.core.MobileSsoFactory;
import com.ca.mas.core.auth.QRCodeRenderer;
import com.ca.mas.core.error.MAGError;
import com.ca.mas.core.service.Provider;
import com.ca.mas.foundation.MAS;
import com.ca.mas.foundation.MASCallback;
import com.ca.mas.foundation.MASResponse;
import com.ca.mas.foundation.auth.MASAuthenticationProvider;
import com.ca.mas.foundation.auth.MASAuthenticationProviders;
import com.ca.mas.foundation.auth.MASProximityLogin;
import com.ca.mas.foundation.notify.Callback;

public class MASProximityLoginQRCode
extends QRCodeRenderer
implements MASProximityLogin {
    public static void authorize(String authenticateUrl, final MASCallback<Void> callback) {
        MobileSsoFactory.getInstance().authorize(authenticateUrl, new MAGResultReceiver(null){

            public void onSuccess(MASResponse response) {
                Callback.onSuccess(callback, null);
            }

            @Override
            public void onError(MAGError error) {
                Callback.onError(callback, error);
            }

            @Override
            public void onRequestCancelled(Bundle data) {
                super.onRequestCancelled(data);
                Callback.onError(callback, new MAS.RequestCancelledException(data));
            }
        });
    }

    @Override
    public boolean init(Activity activity, long requestId, MASAuthenticationProviders providers) {
        this.requestId = requestId;
        for (MASAuthenticationProvider p : providers.getProviders()) {
            if (!p.isProximityLogin()) continue;
            return super.init((Context)activity, new Provider(p.getIdentifier(), p.getAuthenticationUrl(), p.getPollUrl(), null));
        }
        return false;
    }

    @Override
    public void start() {
        super.onRenderCompleted();
    }

    @Override
    public void stop() {
        super.close();
    }
}

