/*
 * Decompiled with CFR 0.152.
 */
package com.ca.mas.foundation;

import android.content.Context;
import android.os.Parcel;
import android.os.Parcelable;
import com.ca.mas.core.conf.ConfigurationManager;
import com.ca.mas.foundation.MAS;
import com.ca.mas.foundation.MASCallback;
import com.ca.mas.foundation.MASMultiFactorHandler;
import com.ca.mas.foundation.MASRequest;
import com.ca.mas.foundation.MASResponse;
import com.ca.mas.foundation.notify.Callback;
import java.net.URI;
import java.util.HashMap;
import java.util.List;

public class MASOtpAuthenticationHandler
extends MASMultiFactorHandler {
    private List<String> channels;
    private boolean isInvalidOtp;
    public static final Parcelable.Creator<MASOtpAuthenticationHandler> CREATOR = new Parcelable.Creator<MASOtpAuthenticationHandler>(){

        public MASOtpAuthenticationHandler createFromParcel(Parcel source) {
            return new MASOtpAuthenticationHandler(source);
        }

        public MASOtpAuthenticationHandler[] newArray(int size) {
            return new MASOtpAuthenticationHandler[size];
        }
    };

    public MASOtpAuthenticationHandler(long requestId, List<String> channels, boolean isInvalidOtp) {
        super(requestId);
        this.channels = channels;
        this.isInvalidOtp = isInvalidOtp;
    }

    public void proceed(Context context, String otp) {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("X-OTP", otp);
        this.proceed(context, headers);
    }

    public void deliver(String channels, final MASCallback<Void> callback) {
        String otpAuthUrl = (String)ConfigurationManager.getInstance().getConnectedGatewayConfigurationProvider().getProperty("msso.url.auth_otp");
        URI otpDeliveryUrl = ConfigurationManager.getInstance().getConnectedGatewayConfigurationProvider().getUri(otpAuthUrl);
        MASRequest request = new MASRequest.MASRequestBuilder(otpDeliveryUrl).header("X-OTP-CHANNEL", channels).build();
        MAS.invoke(request, new MASCallback<MASResponse<Void>>(){

            @Override
            public void onSuccess(MASResponse<Void> result) {
                Callback.onSuccess(callback, null);
            }

            @Override
            public void onError(Throwable e) {
                Callback.onError(callback, e);
            }
        });
    }

    public List<String> getChannels() {
        return this.channels;
    }

    public boolean isInvalidOtp() {
        return this.isInvalidOtp;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        super.writeToParcel(dest, flags);
        dest.writeStringList(this.channels);
        dest.writeByte(this.isInvalidOtp ? (byte)1 : 0);
    }

    protected MASOtpAuthenticationHandler(Parcel in) {
        super(in);
        this.channels = in.createStringArrayList();
        this.isInvalidOtp = in.readByte() != 0;
    }
}

