/*
 * Decompiled with CFR 0.152.
 */
package com.ca.mas.foundation;

import android.content.Context;
import android.net.Uri;
import com.ca.mas.core.EventDispatcher;
import com.ca.mas.core.cert.PublicKeyHash;
import com.ca.mas.core.conf.Config;
import com.ca.mas.core.conf.ConfigurationManager;
import com.ca.mas.core.conf.ConfigurationProvider;
import com.ca.mas.foundation.MASSecurityConfiguration;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;

public class MASConfiguration {
    private static Config USERINFO = new Config(false, "mas.url.user_info", "oauth.oauth_protected_endpoints.userinfo_endpoint_path", String.class);
    private static Config MAS_SCIM = new Config(false, "mas.url.scim_path", "mas.scim-path", String.class);
    private static Config MAS_STORAGE = new Config(false, "mas.url.mas_storage_path", "mas.mas-storage-path", String.class);
    private static Config APP_NAME = new Config(false, "application_name", "oauth.client.client_name", String.class);
    private static Config APP_ORGANIZATION = new Config(false, "application_organization", "oauth.client.organization", String.class);
    private static Config APP_REGISTERED_BY = new Config(false, "application_registered_by", "oauth.client.registered_by", String.class);
    private static Config APP_DESCRIPTION = new Config(false, "application_description", "oauth.client.description", String.class);
    private static Config APP_TYPE = new Config(false, "application_type", "oauth.client.client_type", String.class);
    public static Config ID_TOKEN_SIGN_ALG = new Config(false, "id_token_signed_response_alg", "oauth.client.client_ids.0.client_key_custom.openid_registration.response.id_token_signed_response_alg", String.class);
    public static final EventDispatcher SECURITY_CONFIGURATION_CHANGED = new EventDispatcher();
    public static final EventDispatcher SECURITY_CONFIGURATION_RESET = new EventDispatcher();
    private static MASConfiguration currentConfiguration;
    private static Map<Uri, MASSecurityConfiguration> securityConfigurations;

    static MASSecurityConfiguration createPrimaryConfiguration(Uri uri) {
        Collection<PublicKeyHash> publicKeyHashes;
        ConfigurationProvider configurationProvider = ConfigurationManager.getInstance().getConnectedGatewayConfigurationProvider();
        MASSecurityConfiguration.Builder configBuilder = new MASSecurityConfiguration.Builder().host(uri).trustPublicPKI(configurationProvider.isAlsoTrustPublicPki());
        Collection<X509Certificate> certificates = configurationProvider.getTrustedCertificateAnchors();
        if (certificates != null) {
            for (X509Certificate cert : certificates) {
                configBuilder.add(cert);
            }
        }
        if ((publicKeyHashes = configurationProvider.getTrustedCertificatePinnedPublicKeyHashes()) != null) {
            for (PublicKeyHash hash : publicKeyHashes) {
                String hashString = hash.getHashString();
                configBuilder.add(hashString);
            }
        }
        return configBuilder.build();
    }

    public static MASConfiguration getCurrentConfiguration() {
        if (currentConfiguration == null) {
            throw new IllegalStateException("MAS.start() has not been invoked.");
        }
        return currentConfiguration;
    }

    protected MASConfiguration(Context context) {
        Context appContext = context.getApplicationContext();
        ConfigurationManager manager = ConfigurationManager.getInstance();
        manager.init(appContext);
        manager.setAppConfigs(Arrays.asList(USERINFO, MAS_SCIM, MAS_STORAGE, APP_NAME, APP_ORGANIZATION, APP_REGISTERED_BY, APP_DESCRIPTION, APP_TYPE, ID_TOKEN_SIGN_ALG));
        currentConfiguration = this;
        SECURITY_CONFIGURATION_RESET.notifyObservers();
    }

    public boolean isLoaded() {
        return true;
    }

    public String getApplicationName() {
        return (String)ConfigurationManager.getInstance().getConnectedGatewayConfigurationProvider().getProperty("application_name");
    }

    public String getApplicationType() {
        return (String)ConfigurationManager.getInstance().getConnectedGatewayConfigurationProvider().getProperty("application_type");
    }

    public String getApplicationDescription() {
        return (String)ConfigurationManager.getInstance().getConnectedGatewayConfigurationProvider().getProperty("application_description");
    }

    public String getApplicationOrganization() {
        return (String)ConfigurationManager.getInstance().getConnectedGatewayConfigurationProvider().getProperty("application_organization");
    }

    public String getApplicationRegisteredBy() {
        return (String)ConfigurationManager.getInstance().getConnectedGatewayConfigurationProvider().getProperty("application_registered_by");
    }

    public String getIdTokenSignAlg() {
        return (String)ConfigurationManager.getInstance().getConnectedGatewayConfigurationProvider().getProperty("id_token_signed_response_alg");
    }

    public Collection<X509Certificate> getGatewayCertificates() {
        return ConfigurationManager.getInstance().getConnectedGatewayConfigurationProvider().getTrustedCertificateAnchors();
    }

    public String getGatewayHostName() {
        return ConfigurationManager.getInstance().getConnectedGatewayConfigurationProvider().getTokenHost();
    }

    public int getGatewayPort() {
        return ConfigurationManager.getInstance().getConnectedGatewayConfigurationProvider().getTokenPort();
    }

    public String getGatewayPrefix() {
        return ConfigurationManager.getInstance().getConnectedGatewayConfigurationProvider().getPrefix();
    }

    public URL getGatewayUrl() {
        try {
            return ConfigurationManager.getInstance().getConnectedGatewayConfigurationProvider().getUri(null).toURL();
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }

    public boolean getLocationIsRequired() {
        return (Boolean)ConfigurationManager.getInstance().getConnectedGatewayConfigurationProvider().getProperty("msso.location.enabled");
    }

    public boolean isEnabledPublicKeyPinning() {
        return ConfigurationManager.getInstance().getConnectedGatewayConfigurationProvider().getTrustedCertificatePinnedPublicKeyHashes() != null && ConfigurationManager.getInstance().getConnectedGatewayConfigurationProvider().getTrustedCertificatePinnedPublicKeyHashes().size() > 0;
    }

    public boolean isEnabledTrustedPublicPKI() {
        return ConfigurationManager.getInstance().getConnectedGatewayConfigurationProvider().isAlsoTrustPublicPki();
    }

    public boolean isSsoEnabled() {
        return (Boolean)ConfigurationManager.getInstance().getConnectedGatewayConfigurationProvider().getProperty("msso.sso.enabled");
    }

    public String getEndpointPath(String key) {
        return (String)ConfigurationManager.getInstance().getConnectedGatewayConfigurationProvider().getProperty(key);
    }

    public void setCertificateAdvancedRenewTimeframe(int numDays) {
        ConfigurationManager.getInstance().setCertificateAdvancedRenewTimeframe(numDays);
    }

    public int getCertificateAdvancedRenewTimeframe() {
        return ConfigurationManager.getInstance().getCertificateAdvancedRenewTimeframe();
    }

    public void addSecurityConfiguration(MASSecurityConfiguration securityConfiguration) {
        Uri sanitizedHost = this.getSanitizedHost(securityConfiguration.getHost());
        securityConfigurations.put(sanitizedHost, securityConfiguration);
        SECURITY_CONFIGURATION_CHANGED.notifyObservers(securityConfiguration.getHost());
    }

    public void removeSecurityConfiguration(Uri uri) {
        Uri sanitizedHost = this.getSanitizedHost(uri);
        if (securityConfigurations.remove(sanitizedHost) != null) {
            SECURITY_CONFIGURATION_CHANGED.notifyObservers(uri);
        }
    }

    public MASSecurityConfiguration getSecurityConfiguration(Uri uri) {
        Uri sanitizedHost = this.getSanitizedHost(uri);
        return securityConfigurations.get(sanitizedHost);
    }

    private Uri getSanitizedHost(Uri uri) {
        return new Uri.Builder().encodedAuthority(uri.getHost() + ":" + uri.getPort()).build();
    }

    static {
        securityConfigurations = new HashMap<Uri, MASSecurityConfiguration>();
        EventDispatcher.STARTED.addObserver(new Observer(){

            @Override
            public void update(Observable o, Object arg) {
                Uri uri = new Uri.Builder().encodedAuthority(ConfigurationManager.getInstance().getConnectedGateway().getHost() + ":" + ConfigurationManager.getInstance().getConnectedGateway().getPort()).build();
                MASSecurityConfiguration primaryConfig = MASConfiguration.createPrimaryConfiguration(uri);
                securityConfigurations.put(uri, primaryConfig);
            }
        });
        EventDispatcher.STOP.addObserver(new Observer(){

            @Override
            public void update(Observable o, Object arg) {
                if (currentConfiguration != null) {
                    try {
                        Uri uri = new Uri.Builder().encodedAuthority(currentConfiguration.getGatewayHostName() + ":" + currentConfiguration.getGatewayPort()).build();
                        securityConfigurations.remove(uri);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        });
    }
}

