/*
 * Decompiled with CFR 0.152.
 */
package com.ca.mas.core.token;

import android.support.annotation.NonNull;
import android.util.Base64;
import com.ca.mas.core.token.IdToken;
import org.json.JSONException;
import org.json.JSONObject;

public class IdTokenDef {
    private byte[] header;
    private byte[] payload;
    private byte[] signature;

    IdTokenDef(@NonNull IdToken idToken) {
        byte[] token = idToken.getValue().getBytes();
        byte[][] splitToken = this.split(token);
        this.header = splitToken[0];
        this.payload = splitToken[1];
        this.signature = null;
        if (splitToken.length == 3) {
            this.signature = splitToken[2];
        }
    }

    public byte[] getHeader() {
        return this.header;
    }

    public byte[] getSignature() {
        return this.signature;
    }

    public byte[] getPayload() {
        return this.payload;
    }

    public JSONObject getPayloadAsJSONObject() throws JSONException {
        byte[] decodedPayload = Base64.decode((byte[])this.payload, (int)8);
        String payloadData = new String(decodedPayload);
        return new JSONObject(payloadData);
    }

    private byte[][] split(byte[] token) {
        String tokenString = new String(token);
        String[] tokenParts = tokenString.split("[.]");
        if (tokenParts.length < 2 || tokenParts.length > 3) {
            return null;
        }
        byte[][] splitBytes = new byte[tokenParts.length][];
        splitBytes[0] = new byte[tokenParts[0].getBytes().length];
        splitBytes[1] = new byte[tokenParts[1].getBytes().length];
        System.arraycopy(tokenParts[0].getBytes(), 0, splitBytes[0], 0, tokenParts[0].getBytes().length);
        System.arraycopy(tokenParts[1].getBytes(), 0, splitBytes[1], 0, tokenParts[1].getBytes().length);
        if (splitBytes.length == 3) {
            splitBytes[2] = new byte[tokenParts[2].getBytes().length];
            System.arraycopy(tokenParts[2].getBytes(), 0, splitBytes[2], 0, tokenParts[2].getBytes().length);
        }
        return splitBytes;
    }
}

