/*
 * Decompiled with CFR 0.152.
 */
package com.ca.mas.core.service;

import android.os.Bundle;
import com.ca.mas.core.service.MssoRequest;
import com.ca.mas.core.util.Functions;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;

class MssoRequestQueue {
    private static final MssoRequestQueue INSTANCE = new MssoRequestQueue();
    private final Map<Long, MssoRequest> inboundRequests = new LinkedHashMap<Long, MssoRequest>();

    private MssoRequestQueue() {
    }

    public static MssoRequestQueue getInstance() {
        return INSTANCE;
    }

    synchronized void addRequest(MssoRequest request) {
        this.inboundRequests.put(request.getId(), request);
    }

    synchronized MssoRequest getRequest(long requestId) {
        return this.inboundRequests.get(requestId);
    }

    synchronized MssoRequest takeRequest(long requestId) {
        return this.inboundRequests.remove(requestId);
    }

    synchronized void removeMatching(Functions.Unary<Boolean, MssoRequest> predicate, Bundle data) {
        Iterator<MssoRequest> it = this.inboundRequests.values().iterator();
        while (it.hasNext()) {
            MssoRequest mssoRequest = it.next();
            if (!predicate.call(mssoRequest).booleanValue()) continue;
            if (mssoRequest.getResultReceiver() != null) {
                mssoRequest.getResultReceiver().send(2, data);
            }
            it.remove();
        }
    }
}

