/*
 * Decompiled with CFR 0.152.
 */
package com.ca.mas.core.security;

import android.os.Build;
import com.ca.mas.core.security.AndroidJellyBeanKeyRepository;
import com.ca.mas.core.security.AndroidJellyBeanMR2KeyRepository;
import com.ca.mas.core.security.AndroidKitKatKeyRepository;
import com.ca.mas.core.security.AndroidMKeyRepository;
import com.ca.mas.core.security.AndroidNKeyRepository;
import com.ca.mas.core.security.GenerateKeyAttribute;
import com.ca.mas.core.security.KeyStoreException;
import java.security.Key;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;

public abstract class KeyStoreRepository {
    private static final KeyStoreRepository keyStoreRepository;
    private static final boolean pinRequired;

    public abstract Key getPrivateKey(String var1) throws KeyStoreException;

    public abstract Key getPublicKey(String var1) throws KeyStoreException;

    public abstract void deleteKey(String var1);

    public abstract KeyPair createPrivateKey(String var1, GenerateKeyAttribute var2) throws KeyStoreException;

    public abstract void saveCertificateChain(String var1, X509Certificate[] var2) throws KeyStoreException;

    public abstract X509Certificate[] getCertificateChain(String var1) throws KeyStoreException;

    public abstract void deleteCertificateChain(String var1);

    public abstract byte[] generateCertificateSigningRequest(String var1, String var2, String var3, String var4, PrivateKey var5, PublicKey var6) throws CertificateException;

    public static KeyStoreRepository getKeyStoreRepository() {
        return keyStoreRepository;
    }

    public static boolean isPinRequired() {
        return pinRequired;
    }

    static {
        switch (Build.VERSION.SDK_INT) {
            case 16: 
            case 17: {
                pinRequired = true;
                keyStoreRepository = new AndroidJellyBeanKeyRepository();
                break;
            }
            case 18: {
                pinRequired = false;
                keyStoreRepository = new AndroidJellyBeanMR2KeyRepository();
                break;
            }
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                pinRequired = false;
                keyStoreRepository = new AndroidKitKatKeyRepository();
                break;
            }
            case 23: {
                pinRequired = false;
                keyStoreRepository = new AndroidMKeyRepository();
                break;
            }
            case 24: {
                pinRequired = false;
                keyStoreRepository = new AndroidNKeyRepository();
                break;
            }
            default: {
                pinRequired = false;
                keyStoreRepository = new AndroidNKeyRepository();
            }
        }
    }
}

