/*
 * Decompiled with CFR 0.152.
 */
package com.ca.mas.core.policy;

import android.content.Context;
import android.support.annotation.NonNull;
import com.ca.mas.core.context.MssoContext;
import com.ca.mas.core.oauth.OAuthClientUtil;
import com.ca.mas.core.policy.MssoAssertion;
import com.ca.mas.core.policy.RequestInfo;
import com.ca.mas.core.security.SecureLockException;
import com.ca.mas.core.store.TokenManager;
import com.ca.mas.foundation.MAS;
import com.ca.mas.foundation.MASRequest;
import com.ca.mas.foundation.MASResponse;

class SecureLockAssertion
implements MssoAssertion {
    private TokenManager tokenManager;

    SecureLockAssertion() {
    }

    @Override
    public void init(@NonNull MssoContext mssoContext, @NonNull Context sysContext) {
        this.tokenManager = mssoContext.getTokenManager();
        if (mssoContext.getConfigurationProvider() == null) {
            throw new NullPointerException("ConfigurationProvider is null");
        }
    }

    @Override
    public void processRequest(MssoContext mssoContext, RequestInfo request) {
        byte[] secureToken = this.tokenManager.getSecureIdToken();
        if (secureToken != null) {
            MASRequest revokeRequest = OAuthClientUtil.getRevokeRequest();
            if (revokeRequest != null) {
                MAS.invoke(OAuthClientUtil.getRevokeRequest(), null);
            }
            mssoContext.clearAccessToken();
            throw new SecureLockException("The session is currently locked.");
        }
    }

    @Override
    public void processResponse(MssoContext mssoContext, RequestInfo request, MASResponse response) {
    }

    @Override
    public void close() {
    }
}

