/*
 * Decompiled with CFR 0.152.
 */
package com.ca.mas.core.policy;

import android.content.Context;
import com.ca.mas.core.conf.ConfigurationManager;
import com.ca.mas.core.context.MssoContext;
import com.ca.mas.core.error.MAGException;
import com.ca.mas.core.error.MAGServerException;
import com.ca.mas.core.policy.AccessTokenAssertion;
import com.ca.mas.core.policy.ClientCredentialAssertion;
import com.ca.mas.core.policy.CustomHeaderAssertion;
import com.ca.mas.core.policy.DeviceRegistrationAssertion;
import com.ca.mas.core.policy.LocationAssertion;
import com.ca.mas.core.policy.MssoAssertion;
import com.ca.mas.core.policy.RequestInfo;
import com.ca.mas.core.policy.ResponseRecoveryAssertion;
import com.ca.mas.core.policy.SecureLockAssertion;
import com.ca.mas.core.policy.StorageReadyAssertion;
import com.ca.mas.core.policy.TelephoneAssertion;
import com.ca.mas.foundation.MASResponse;
import java.io.IOException;
import java.net.URI;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class PolicyManager {
    private final MssoContext mssoContext;
    private final Object policySync = new Object();
    private final Map<String, List<MssoAssertion>> policies = new HashMap<String, List<MssoAssertion>>();
    private List<MssoAssertion> defaultPolicy;

    public PolicyManager(MssoContext mssoContext) {
        this.mssoContext = mssoContext;
        StorageReadyAssertion storageReadyAssertion = new StorageReadyAssertion();
        SecureLockAssertion secureLockAssertion = new SecureLockAssertion();
        ClientCredentialAssertion clientCredentialAssertion = new ClientCredentialAssertion();
        DeviceRegistrationAssertion deviceRegistrationAssertion = new DeviceRegistrationAssertion();
        AccessTokenAssertion accessTokenAssertion = new AccessTokenAssertion();
        LocationAssertion locationAssertion = new LocationAssertion();
        TelephoneAssertion telephoneAssertion = new TelephoneAssertion();
        CustomHeaderAssertion customHeaderAssertion = new CustomHeaderAssertion();
        ResponseRecoveryAssertion responseRecoveryAssertion = new ResponseRecoveryAssertion();
        this.defaultPolicy = Arrays.asList(storageReadyAssertion, secureLockAssertion, clientCredentialAssertion, deviceRegistrationAssertion, accessTokenAssertion, locationAssertion, telephoneAssertion, customHeaderAssertion, responseRecoveryAssertion);
        URI logout = ConfigurationManager.getInstance().getConnectedGatewayConfigurationProvider().getTokenUri("msso.url.resource_owner_logout");
        URI revoke = ConfigurationManager.getInstance().getConnectedGatewayConfigurationProvider().getTokenUri("msso.url.usersession_logout_endpoint_path");
        this.policies.put(logout.getPath(), Arrays.asList(storageReadyAssertion, secureLockAssertion, clientCredentialAssertion, locationAssertion, responseRecoveryAssertion));
        this.policies.put(revoke.getPath(), Arrays.asList(storageReadyAssertion, clientCredentialAssertion, locationAssertion, responseRecoveryAssertion));
    }

    public void init(Context sysContext) {
        Context appContext = sysContext.getApplicationContext();
        for (MssoAssertion assertion : this.defaultPolicy) {
            assertion.init(this.mssoContext, appContext);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processRequest(RequestInfo request, List<MssoAssertion> policy) throws MAGException, MAGServerException {
        Object object = this.policySync;
        synchronized (object) {
            for (MssoAssertion assertion : policy) {
                assertion.processRequest(this.mssoContext, request);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processResponse(RequestInfo request, MASResponse response, List<MssoAssertion> policy) throws MAGException, MAGServerException {
        Object object = this.policySync;
        synchronized (object) {
            for (MssoAssertion assertion : policy) {
                assertion.processResponse(this.mssoContext, request, response);
            }
        }
    }

    public MASResponse execute(RequestInfo requestInfo, Route<MASResponse> function) throws MAGException, MAGServerException, IOException {
        String path = requestInfo.getRequest().getURL() == null ? "" : requestInfo.getRequest().getURL().getPath();
        List<MssoAssertion> activePolicy = this.policies.get(path);
        if (activePolicy == null) {
            activePolicy = this.defaultPolicy;
        }
        this.processRequest(requestInfo, activePolicy);
        MASResponse response = function.invoke();
        this.processResponse(requestInfo, response, activePolicy);
        return response;
    }

    public void close() {
        for (MssoAssertion assertion : this.defaultPolicy) {
            assertion.close();
        }
    }

    public static interface Route<R> {
        public R invoke() throws IOException;
    }
}

