/*
 * Decompiled with CFR 0.152.
 */
package com.ca.mas.core.http;

import android.net.Uri;
import com.ca.mas.core.io.ssl.MAGSocketFactory;
import com.ca.mas.foundation.MASConfiguration;
import com.ca.mas.foundation.MASInvalidHostException;
import com.ca.mas.foundation.MASSecurityConfiguration;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import javax.net.ssl.SSLSocketFactory;

public class SSLSocketFactoryProvider {
    private static SSLSocketFactoryProvider instance = new SSLSocketFactoryProvider();
    private Map<Uri, SSLSocketFactory> factories = new HashMap<Uri, SSLSocketFactory>();

    private SSLSocketFactoryProvider() {
        MASConfiguration.SECURITY_CONFIGURATION_CHANGED.addObserver(new Observer(){

            @Override
            public void update(Observable o, Object arg) {
                SSLSocketFactoryProvider.this.factories.remove((Uri)arg);
            }
        });
        MASConfiguration.SECURITY_CONFIGURATION_RESET.addObserver(new Observer(){

            @Override
            public void update(Observable o, Object arg) {
                SSLSocketFactoryProvider.this.factories.clear();
            }
        });
    }

    public static SSLSocketFactoryProvider getInstance() {
        return instance;
    }

    public SSLSocketFactory get(URL url) {
        Uri sanitized = new Uri.Builder().encodedAuthority(url.getHost() + ":" + url.getPort()).build();
        SSLSocketFactory factory = this.factories.get(sanitized);
        if (factory == null) {
            factory = this.getSSLSocketFactory(sanitized);
            this.factories.put(sanitized, factory);
        }
        return factory;
    }

    public SSLSocketFactory getPrimaryGatewaySocketFactory() throws MASInvalidHostException {
        MASConfiguration currentConfiguration = MASConfiguration.getCurrentConfiguration();
        Uri uri = new Uri.Builder().encodedAuthority(currentConfiguration.getGatewayHostName() + ":" + currentConfiguration.getGatewayPort()).build();
        return this.getSSLSocketFactory(uri);
    }

    public SSLSocketFactory getSSLSocketFactory(Uri hostname) throws MASInvalidHostException {
        MASSecurityConfiguration securityConfig;
        MASConfiguration config = MASConfiguration.getCurrentConfiguration();
        if (config != null && (securityConfig = config.getSecurityConfiguration(hostname)) != null) {
            return this.createSSLSocketFactory(securityConfig);
        }
        throw new MASInvalidHostException("Could not find hostname configuration.");
    }

    public SSLSocketFactory createSSLSocketFactory(MASSecurityConfiguration configuration) {
        return new MAGSocketFactory(configuration).createTLSSocketFactory();
    }
}

