/*
 * Decompiled with CFR 0.152.
 */
package com.ca.mas.core.auth.ble;

import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothDevice;
import android.bluetooth.BluetoothGattCharacteristic;
import android.bluetooth.BluetoothGattServer;
import android.bluetooth.BluetoothGattServerCallback;
import android.bluetooth.BluetoothGattService;
import android.bluetooth.BluetoothManager;
import android.bluetooth.le.AdvertiseCallback;
import android.bluetooth.le.AdvertiseData;
import android.bluetooth.le.AdvertiseSettings;
import android.bluetooth.le.BluetoothLeAdvertiser;
import android.content.Context;
import android.os.Build;
import android.os.Bundle;
import android.os.ParcelUuid;
import com.ca.mas.core.MAGResultReceiver;
import com.ca.mas.core.MobileSsoFactory;
import com.ca.mas.core.auth.ble.BluetoothLeConsentHandler;
import com.ca.mas.core.auth.ble.BluetoothLePeripheralCallback;
import com.ca.mas.core.conf.ConfigurationManager;
import com.ca.mas.core.error.MAGError;
import com.ca.mas.core.error.MAGException;
import com.ca.mas.foundation.MASResponse;
import java.util.UUID;
import org.json.JSONException;
import org.json.JSONObject;

public class BluetoothLePeripheral {
    private static final String SUCCESS = "0";
    private static final String CANCEL = "1";
    private static BluetoothLePeripheral instance = new BluetoothLePeripheral();
    private Context appContext;
    private BluetoothLePeripheralCallback callback;
    private BluetoothLeAdvertiser advertiser;
    private BluetoothGattServer server;
    private BluetoothDevice connectedDevice;
    private boolean isAuthenticating = false;

    private BluetoothLePeripheral() {
    }

    public static BluetoothLePeripheral getInstance() {
        return instance;
    }

    public void init(Context context) {
        this.appContext = context.getApplicationContext();
        this.stop();
    }

    public boolean isAuthenticating() {
        return this.isAuthenticating;
    }

    @SuppressLint(value={"MissingPermission"})
    @TargetApi(value=21)
    public synchronized void start(final BluetoothLePeripheralCallback callback) {
        this.callback = this.getCallback(callback);
        if (Build.VERSION.SDK_INT < 21) {
            this.notifyWithError(103);
            return;
        }
        final Context context = this.appContext;
        if (!context.getPackageManager().hasSystemFeature("android.hardware.bluetooth_le")) {
            this.notifyWithError(101);
            return;
        }
        BluetoothManager btManager = (BluetoothManager)context.getSystemService("bluetooth");
        if (btManager == null) {
            this.notifyWithError(101);
            return;
        }
        BluetoothAdapter btAdapter = btManager.getAdapter();
        if (btAdapter == null) {
            this.notifyWithError(101);
            return;
        }
        if (!btAdapter.isEnabled()) {
            this.notifyWithError(100);
            return;
        }
        String uuid = (String)ConfigurationManager.getInstance().getConnectedGatewayConfigurationProvider().getProperty("msso.ble.service.uuid");
        if (uuid == null || uuid.trim().length() == 0) {
            this.notifyWithError(102);
            return;
        }
        UUID serviceUUID = null;
        try {
            serviceUUID = UUID.fromString(uuid);
        }
        catch (IllegalArgumentException e) {
            this.notifyWithError(102);
            return;
        }
        uuid = (String)ConfigurationManager.getInstance().getConnectedGatewayConfigurationProvider().getProperty("msso.ble.characteristic.uuid");
        if (uuid == null || uuid.trim().length() == 0) {
            this.notifyWithError(102);
            return;
        }
        UUID characteristicUUID = null;
        try {
            characteristicUUID = UUID.fromString(uuid);
        }
        catch (IllegalArgumentException e) {
            this.notifyWithError(102);
            return;
        }
        this.advertiser = btAdapter.getBluetoothLeAdvertiser();
        if (this.advertiser == null) {
            this.notifyWithError(122);
            return;
        }
        if (this.server != null) {
            return;
        }
        AdvertiseSettings.Builder settingsBuilder = new AdvertiseSettings.Builder();
        settingsBuilder.setAdvertiseMode(1);
        settingsBuilder.setConnectable(true);
        settingsBuilder.setTimeout(0);
        settingsBuilder.setTxPowerLevel(2);
        AdvertiseData.Builder dataBuilder = new AdvertiseData.Builder();
        dataBuilder.setIncludeTxPowerLevel(true);
        dataBuilder.addServiceUuid(new ParcelUuid(serviceUUID));
        this.advertiser.startAdvertising(settingsBuilder.build(), dataBuilder.build(), new AdvertiseCallback(){

            public void onStartSuccess(AdvertiseSettings settingsInEffect) {
                super.onStartSuccess(settingsInEffect);
            }

            public void onStartFailure(int errorCode) {
                super.onStartFailure(errorCode);
                BluetoothLePeripheral.this.notifyWithError(120);
            }
        });
        final StringBuilder buffer = new StringBuilder();
        this.server = btManager.openGattServer(context, new BluetoothGattServerCallback(){

            public void onConnectionStateChange(BluetoothDevice device, int status, int newState) {
                super.onConnectionStateChange(device, status, newState);
                if (newState == 2) {
                    BluetoothLePeripheral.this.connectedDevice = device;
                    callback.onStatusUpdate(10);
                } else if (newState == 0) {
                    callback.onStatusUpdate(11);
                    BluetoothLePeripheral.this.connectedDevice = null;
                }
            }

            public void onCharacteristicWriteRequest(final BluetoothDevice device, int requestId, final BluetoothGattCharacteristic characteristic, boolean preparedWrite, boolean responseNeeded, int offset, byte[] value) {
                super.onCharacteristicWriteRequest(device, requestId, characteristic, preparedWrite, responseNeeded, offset, value);
                String received = new String(value);
                if (received.equals("EOM")) {
                    String session = null;
                    String deviceName = null;
                    try {
                        JSONObject jsonObject = new JSONObject(buffer.toString());
                        session = jsonObject.getString("provider_url");
                        deviceName = jsonObject.optString("device_name");
                    }
                    catch (JSONException e) {
                        BluetoothLePeripheral.this.notifyWithError(121);
                        return;
                    }
                    buffer.setLength(0);
                    final String finalSession = session;
                    callback.onConsentRequested(deviceName, new BluetoothLeConsentHandler(){

                        @Override
                        public void proceed() {
                            BluetoothLePeripheral.this.isAuthenticating = true;
                            MobileSsoFactory.getInstance(context).authorize(finalSession, new MAGResultReceiver(){

                                public void onSuccess(MASResponse response) {
                                    BluetoothLePeripheral.this.isAuthenticating = false;
                                    if (response.getResponseCode() == 200) {
                                        characteristic.setValue(BluetoothLePeripheral.SUCCESS);
                                        callback.onStatusUpdate(14);
                                        try {
                                            BluetoothLePeripheral.this.server.notifyCharacteristicChanged(device, characteristic, true);
                                            callback.onStatusUpdate(15);
                                        }
                                        catch (Exception e) {
                                            callback.onError(123);
                                        }
                                    } else {
                                        this.onError(new MAGError(new MAGException(-1, "Server response with error.")));
                                    }
                                }

                                @Override
                                public void onError(MAGError error) {
                                    BluetoothLePeripheral.this.isAuthenticating = false;
                                    characteristic.setValue(error.getMessage());
                                    BluetoothLePeripheral.this.notifyWithError(121);
                                    try {
                                        BluetoothLePeripheral.this.server.notifyCharacteristicChanged(device, characteristic, true);
                                        callback.onStatusUpdate(15);
                                    }
                                    catch (Exception e) {
                                        callback.onError(123);
                                    }
                                }

                                @Override
                                public void onRequestCancelled(Bundle bundle) {
                                }
                            });
                        }

                        @Override
                        public void cancel() {
                            characteristic.setValue(BluetoothLePeripheral.CANCEL);
                            BluetoothLePeripheral.this.server.notifyCharacteristicChanged(device, characteristic, true);
                        }
                    });
                } else {
                    buffer.append(received);
                }
            }
        });
        BluetoothGattService service = new BluetoothGattService(serviceUUID, 0);
        BluetoothGattCharacteristic characteristic = new BluetoothGattCharacteristic(characteristicUUID, 20, 17);
        service.addCharacteristic(characteristic);
        if (this.server != null) {
            this.server.addService(service);
            callback.onStatusUpdate(12);
        } else {
            callback.onError(120);
        }
    }

    @TargetApi(value=21)
    public synchronized void stop() {
        if (Build.VERSION.SDK_INT < 21) {
            this.notifyWithError(101);
            return;
        }
        if (this.advertiser != null) {
            try {
                this.advertiser.stopAdvertising(new AdvertiseCallback(){

                    public void onStartSuccess(AdvertiseSettings settingsInEffect) {
                        super.onStartSuccess(settingsInEffect);
                    }

                    public void onStartFailure(int errorCode) {
                        super.onStartFailure(errorCode);
                    }
                });
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.server != null) {
            try {
                if (this.connectedDevice != null) {
                    this.server.cancelConnection(this.connectedDevice);
                }
                this.server.clearServices();
                this.server.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.getCallback(this.callback).onStatusUpdate(13);
        }
        this.server = null;
        this.connectedDevice = null;
    }

    private void notifyWithError(int errorCode) {
        this.getCallback(this.callback).onError(errorCode);
    }

    private BluetoothLePeripheralCallback getCallback(BluetoothLePeripheralCallback callback) {
        if (callback == null) {
            return new BluetoothLePeripheralCallback(){

                @Override
                public void onStatusUpdate(int state) {
                }

                @Override
                public void onError(int errorCode) {
                }

                @Override
                public void onConsentRequested(String deviceName, BluetoothLeConsentHandler handler) {
                }
            };
        }
        return callback;
    }
}

