/*
 * Decompiled with CFR 0.152.
 */
package com.ca.mas.foundation;

import android.net.Uri;
import java.security.cert.Certificate;
import java.util.ArrayList;
import java.util.List;

public interface MASSecurityConfiguration {
    public Uri getHost();

    public boolean isPublic();

    public boolean trustPublicPki();

    public List<Certificate> getCertificates();

    public List<String> getPublicKeyHashes();

    public static class Builder {
        private boolean isPublic;
        private boolean trustPublicPKI;
        private List<Certificate> certificates;
        private List<String> publicKeyHashes;
        private Uri host;

        public Builder isPublic(boolean p) {
            this.isPublic = p;
            return this;
        }

        public Builder trustPublicPKI(boolean trust) {
            this.trustPublicPKI = trust;
            return this;
        }

        public Builder host(Uri host) {
            this.host = new Uri.Builder().encodedAuthority(host.getHost() + ":" + host.getPort()).build();
            return this;
        }

        public Builder add(Certificate certificate) {
            if (this.certificates == null) {
                this.certificates = new ArrayList<Certificate>();
            }
            this.certificates.add(certificate);
            return this;
        }

        public Builder add(String publicKeyHash) {
            if (this.publicKeyHashes == null) {
                this.publicKeyHashes = new ArrayList<String>();
            }
            this.publicKeyHashes.add(publicKeyHash);
            return this;
        }

        public MASSecurityConfiguration build() {
            if (this.host == null) {
                throw new IllegalArgumentException("Missing host.");
            }
            if (!this.trustPublicPKI && this.publicKeyHashes == null && this.certificates == null) {
                throw new IllegalArgumentException("Missing pinning type, cannot establish SSL.");
            }
            return new MASSecurityConfiguration(){

                @Override
                public Uri getHost() {
                    return Builder.this.host;
                }

                @Override
                public boolean isPublic() {
                    return Builder.this.isPublic;
                }

                @Override
                public List<Certificate> getCertificates() {
                    return Builder.this.certificates;
                }

                @Override
                public List<String> getPublicKeyHashes() {
                    return Builder.this.publicKeyHashes;
                }

                @Override
                public boolean trustPublicPki() {
                    return Builder.this.trustPublicPKI;
                }
            };
        }
    }
}

