/*
 * Decompiled with CFR 0.152.
 */
package com.ca.mas.foundation;

import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import com.ca.mas.core.service.MssoService;
import com.ca.mas.foundation.MAS;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public class MASMultiFactorHandler
implements Parcelable {
    private long requestId;
    private Map<String, String> previousAdditionalHeaders;
    public static final Parcelable.Creator<MASMultiFactorHandler> CREATOR = new Parcelable.Creator<MASMultiFactorHandler>(){

        public MASMultiFactorHandler createFromParcel(Parcel source) {
            return new MASMultiFactorHandler(source);
        }

        public MASMultiFactorHandler[] newArray(int size) {
            return new MASMultiFactorHandler[size];
        }
    };

    public MASMultiFactorHandler(long requestId) {
        this.requestId = requestId;
    }

    public void proceed(Context context, Map<String, String> additionalHeaders) {
        Intent intent = new Intent("com.ca.mas.core.service.action.PROCESS_REQUEST");
        intent.putExtra("com.ca.mas.core.service.req.extra.requestId", this.requestId);
        if (this.previousAdditionalHeaders != null) {
            this.previousAdditionalHeaders.putAll(additionalHeaders);
        } else {
            this.previousAdditionalHeaders = additionalHeaders;
        }
        intent.putExtra("com.ca.mas.core.service.req.extra.additional.headers", (Serializable)((Object)this.previousAdditionalHeaders));
        MssoService.enqueueWork(context, intent);
    }

    public void cancel() {
        MAS.cancelRequest(this.requestId);
    }

    public void cancel(Bundle data) {
        MAS.cancelRequest(this.requestId, data);
    }

    void setPreviousAdditionalHeaders(Map<String, String> previousAdditionalHeaders) {
        this.previousAdditionalHeaders = previousAdditionalHeaders;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeLong(this.requestId);
        if (this.previousAdditionalHeaders == null) {
            dest.writeInt(0);
        } else {
            dest.writeInt(this.previousAdditionalHeaders.size());
            for (Map.Entry<String, String> entry : this.previousAdditionalHeaders.entrySet()) {
                dest.writeString(entry.getKey());
                dest.writeString(entry.getValue());
            }
        }
    }

    protected MASMultiFactorHandler(Parcel in) {
        this.requestId = in.readLong();
        int previousAdditionalHeadersSize = in.readInt();
        if (previousAdditionalHeadersSize > 0) {
            this.previousAdditionalHeaders = new HashMap<String, String>(previousAdditionalHeadersSize);
            for (int i = 0; i < previousAdditionalHeadersSize; ++i) {
                String key = in.readString();
                String value = in.readString();
                this.previousAdditionalHeaders.put(key, value);
            }
        }
    }
}

