/*
 * Decompiled with CFR 0.152.
 */
package com.ca.mas.foundation;

import com.ca.mas.foundation.MASClaims;
import com.ca.mas.foundation.MASException;
import com.nimbusds.jose.JOSEException;
import com.nimbusds.jose.JWSAlgorithm;
import com.nimbusds.jose.JWSHeader;
import com.nimbusds.jose.JWSSigner;
import com.nimbusds.jose.crypto.RSASSASigner;
import com.nimbusds.jwt.JWTClaimsSet;
import com.nimbusds.jwt.SignedJWT;
import java.io.IOException;
import java.security.PrivateKey;
import java.util.Map;
import net.minidev.json.JSONStyle;
import net.minidev.json.JSONValue;
import net.minidev.json.reader.JsonWriterI;
import org.json.JSONObject;

class JWTSign {
    private JWTSign() {
    }

    static String sign(MASClaims masClaims, PrivateKey privateKey) throws MASException {
        JsonWriterI i = JSONValue.defaultWriter.getWriterByInterface(JSONObject.class);
        if (i == null) {
            JSONValue.defaultWriter.registerWriter((JsonWriterI)new JsonWriterI<JSONObject>(){

                public void writeJSONString(JSONObject value, Appendable out, JSONStyle compression) throws IOException {
                    out.append(value.toString());
                }
            }, new Class[]{JSONObject.class});
        }
        RSASSASigner signer = new RSASSASigner(privateKey);
        JWTClaimsSet.Builder claimBuilder = new JWTClaimsSet.Builder();
        claimBuilder.jwtID(masClaims.getJwtId()).issuer(masClaims.getIssuer()).notBeforeTime(masClaims.getNotBefore()).expirationTime(masClaims.getExpirationTime()).issueTime(masClaims.getIssuedAt()).audience(masClaims.getAudience()).subject(masClaims.getSubject());
        for (Map.Entry<String, Object> entry : masClaims.getClaims().entrySet()) {
            claimBuilder.claim(entry.getKey(), entry.getValue());
        }
        JWSHeader rs256Header = new JWSHeader(JWSAlgorithm.RS256);
        SignedJWT claimsToken = new SignedJWT(rs256Header, claimBuilder.build());
        try {
            claimsToken.sign((JWSSigner)signer);
            return claimsToken.serialize();
        }
        catch (JOSEException e) {
            throw new MASException(e);
        }
    }
}

