/*
 * Decompiled with CFR 0.152.
 */
package com.ca.mas.core.token;

import com.ca.mas.core.token.JWTHmacValidator;
import com.ca.mas.core.token.JWTRS256Validator;
import com.ca.mas.core.token.JWTValidationException;
import com.ca.mas.core.token.JWTValidator;

public class JWTValidatorFactory {
    private JWTValidatorFactory() {
    }

    public static JWTValidator getValidator(String algorithm) throws JWTValidationException {
        JWTValidator jwtValidator = null;
        if (algorithm.equals(Algorithm.HS256.toString())) {
            jwtValidator = new JWTHmacValidator();
        } else if (algorithm.equals(Algorithm.RS256.toString())) {
            jwtValidator = new JWTRS256Validator();
        } else {
            throw new JWTValidationException(130106);
        }
        return jwtValidator;
    }

    public static enum Algorithm {
        HS256(1),
        RSA(2),
        RS256(3);

        private int value;

        private Algorithm(int value) {
            this.value = value;
        }
    }
}

