/*
 * Decompiled with CFR 0.152.
 */
package com.ca.mas.core.token;

import android.util.Base64;
import com.ca.mas.core.context.MssoContext;
import com.ca.mas.core.token.IdToken;
import com.ca.mas.core.token.IdTokenDef;
import com.ca.mas.core.token.JWTInvalidSignatureException;
import com.ca.mas.core.token.JWTValidationException;
import com.ca.mas.core.token.JWTValidator;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;

class JWTHmacValidator
implements JWTValidator {
    JWTHmacValidator() {
    }

    @Override
    public boolean validate(MssoContext context, IdToken token) throws JWTValidationException {
        byte[] decodedSignature;
        IdTokenDef idTokenDef = new IdTokenDef(token);
        byte[] header = idTokenDef.getHeader();
        byte[] payload = idTokenDef.getPayload();
        byte[] signature = idTokenDef.getSignature();
        String clientSecret = context.getClientSecret();
        byte[] signToCompare = this.signData(header, payload, clientSecret.getBytes());
        if (!new String(signToCompare).equals(new String(decodedSignature = Base64.decode((byte[])signature, (int)8)))) {
            throw new JWTInvalidSignatureException("Token Validation Failed: The signatures do not match");
        }
        return true;
    }

    private byte[] signData(byte[] header, byte[] payload, byte[] secret) throws JWTValidationException {
        try {
            if (secret == null || secret.length == 0) {
                return null;
            }
            Mac mac = Mac.getInstance("HMACSHA256");
            mac.init(new SecretKeySpec(secret, "HMACSHA256"));
            byte[] jwsSecuredInput = this.createSecuredInput(header, payload);
            byte[] signature = mac.doFinal(jwsSecuredInput);
            return signature;
        }
        catch (Exception e) {
            throw new JWTInvalidSignatureException("Sign Data failed: " + e.getMessage(), (Throwable)e);
        }
    }

    private byte[] createSecuredInput(byte[] header, byte[] payload) {
        byte[] separator = ".".getBytes();
        byte[] jwsSecuredInput = new byte[header.length + separator.length + payload.length];
        System.arraycopy(header, 0, jwsSecuredInput, 0, header.length);
        System.arraycopy(separator, 0, jwsSecuredInput, header.length, separator.length);
        System.arraycopy(payload, 0, jwsSecuredInput, header.length + separator.length, payload.length);
        return jwsSecuredInput;
    }
}

