/*
 * Decompiled with CFR 0.152.
 */
package com.ca.mas.core.cert;

import android.util.Base64;
import android.util.Log;
import com.ca.mas.foundation.MAS;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;

public class CertUtils {
    private static final String PEM_CERT_BEGIN_MARKER = "-----BEGIN CERTIFICATE-----";
    private static final String PEM_CERT_END_MARKER = "-----END CERTIFICATE-----";

    public static X509Certificate decodeCertFromPem(String certificateText) throws IOException {
        String base64Certificate;
        int startIndex = certificateText.indexOf(PEM_CERT_BEGIN_MARKER);
        int endIndex = certificateText.indexOf(PEM_CERT_END_MARKER);
        if (startIndex < 0 || endIndex < startIndex) {
            if (endIndex >= 0) {
                throw new IOException("Begin PEM marker present, but end marker missing");
            }
            base64Certificate = certificateText;
        } else {
            base64Certificate = certificateText.substring(startIndex + PEM_CERT_BEGIN_MARKER.length(), endIndex);
        }
        base64Certificate = base64Certificate.replace("\\/", "/");
        byte[] bytes = Base64.decode((String)base64Certificate, (int)0);
        try {
            return (X509Certificate)CertificateFactory.getInstance("X.509").generateCertificate(new ByteArrayInputStream(bytes));
        }
        catch (CertificateException e) {
            if (MAS.DEBUG) {
                Log.e((String)"MAS", (String)("Unable to decode public certificate, error: " + e + " for cert " + certificateText), (Throwable)e);
            }
            throw new IOException(e);
        }
    }

    private static X509Certificate[] toX509CertArray(Collection<? extends Certificate> certs) {
        ArrayList<X509Certificate> x509Certs = new ArrayList<X509Certificate>();
        for (Certificate certificate : certs) {
            x509Certs.add((X509Certificate)certificate);
        }
        return x509Certs.toArray(new X509Certificate[x509Certs.size()]);
    }

    public static X509Certificate[] decodeCertificateChain(byte[] chainBytes) {
        try {
            return CertUtils.toX509CertArray(CertificateFactory.getInstance("X.509").generateCertificates(new ByteArrayInputStream(chainBytes)));
        }
        catch (Exception e) {
            if (MAS.DEBUG) {
                Log.e((String)"MAS", (String)("Unable to decode certificate chain: " + e), (Throwable)e);
            }
            throw new IllegalArgumentException(e);
        }
    }

    public static byte[] encodeCertificateChain(X509Certificate[] chain) {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            for (X509Certificate cert : chain) {
                baos.write(cert.getEncoded());
            }
            return baos.toByteArray();
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
    }

    private CertUtils() {
    }
}

