/*
 * Decompiled with CFR 0.152.
 */
package com.ca.mas.core;

import com.ca.mas.foundation.MASCallback;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;

public class MASCallbackFuture<T>
extends MASCallback<T>
implements Future<T> {
    private CountDownLatch countDownLatch = new CountDownLatch(1);
    private boolean done = false;
    private T result;
    private Throwable throwableResult;

    @Override
    public void onSuccess(T result) {
        this.result = result;
        this.done = true;
        this.countDownLatch.countDown();
    }

    @Override
    public void onError(Throwable e) {
        this.throwableResult = e;
        this.done = true;
        this.countDownLatch.countDown();
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        throw new UnsupportedOperationException("Unsupported Operation");
    }

    @Override
    public boolean isCancelled() {
        return false;
    }

    @Override
    public boolean isDone() {
        return this.done;
    }

    @Override
    public T get() throws InterruptedException, ExecutionException {
        if (!this.done) {
            this.countDownLatch.await();
        }
        if (this.throwableResult != null) {
            throw new ExecutionException(this.throwableResult);
        }
        return this.result;
    }

    @Override
    public T get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException {
        if (!this.done) {
            this.countDownLatch.await(timeout, unit);
        }
        if (this.throwableResult != null) {
            throw new ExecutionException(this.throwableResult);
        }
        return this.result;
    }
}

