/*
 * Decompiled with CFR 0.152.
 */
package com.ca.mas.foundation;

import android.net.Uri;
import android.util.Base64;
import com.ca.mas.core.conf.ConfigurationManager;
import com.ca.mas.core.store.StorageProvider;
import com.ca.mas.foundation.MASDevice;
import java.security.SecureRandom;

class AuthClientDefaults {
    private String clientId = StorageProvider.getInstance().getClientCredentialContainer().getClientId();
    private String display = "template";
    private Uri redirectUri;
    private String responseType = "code";
    private String scope = (String)ConfigurationManager.getInstance().getConnectedGatewayConfigurationProvider().getProperty("msso.oauth.scope");
    private String state;

    AuthClientDefaults() {
        String redirectUrl = (String)ConfigurationManager.getInstance().getConnectedGatewayConfigurationProvider().getProperty("msso.authorize.redirect.uri");
        this.redirectUri = Uri.parse((String)redirectUrl);
        SecureRandom secureRandom = new SecureRandom();
        byte[] random = new byte[16];
        secureRandom.nextBytes(random);
        this.state = Base64.encodeToString((byte[])random, (int)11);
    }

    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public String getDisplay() {
        return this.display;
    }

    public void setDisplay(String display) {
        this.display = display;
    }

    public Uri getRedirectUri() {
        return this.redirectUri;
    }

    public void setRedirectUri(Uri redirectUri) {
        this.redirectUri = redirectUri;
    }

    public String getResponseType() {
        return this.responseType;
    }

    public void setResponseType(String responseType) {
        this.responseType = responseType;
    }

    public String getScope() {
        if (MASDevice.getCurrentDevice().isRegistered()) {
            return this.scope.replace("msso_client_register ", "").replace("msso_register ", "");
        }
        return this.scope;
    }

    public void setScope(String scope) {
        this.scope = scope;
    }

    public String getState() {
        return this.state;
    }

    public void setState(String state) {
        this.state = state;
    }
}

