/*
 * Decompiled with CFR 0.152.
 */
package com.ca.mas.core.oauth;

import android.net.Uri;
import android.util.Base64;
import android.util.Log;
import android.util.Pair;
import com.ca.mas.core.conf.ConfigurationManager;
import com.ca.mas.core.io.Charsets;
import com.ca.mas.core.io.IoUtils;
import com.ca.mas.core.oauth.PKCE;
import com.ca.mas.core.store.ClientCredentialContainer;
import com.ca.mas.core.store.OAuthTokenContainer;
import com.ca.mas.core.store.StorageProvider;
import com.ca.mas.core.store.TokenManager;
import com.ca.mas.core.token.IdToken;
import com.ca.mas.foundation.MAS;
import com.ca.mas.foundation.MASConfiguration;
import com.ca.mas.foundation.MASConnectionListener;
import com.ca.mas.foundation.MASRequest;
import com.ca.mas.foundation.MASRequestBody;
import com.ca.mas.foundation.MASResponseBody;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URI;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.ArrayList;

public class OAuthClientUtil {
    private OAuthClientUtil() {
    }

    public static PKCE generateCodeChallenge() {
        int encodeFlags = 11;
        byte[] randomBytes = new byte[64];
        new SecureRandom().nextBytes(randomBytes);
        String codeVerifier = Base64.encodeToString((byte[])randomBytes, (int)encodeFlags);
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("SHA-256");
            messageDigest.update(codeVerifier.getBytes("ISO_8859_1"));
            byte[] digestBytes = messageDigest.digest();
            return new PKCE("S256", Base64.encodeToString((byte[])digestBytes, (int)encodeFlags), codeVerifier);
        }
        catch (NoSuchAlgorithmException e) {
            if (MAS.DEBUG) {
                Log.w((String)"SHA-256 not supported", (Throwable)e);
            }
            return new PKCE("plain", codeVerifier, codeVerifier);
        }
        catch (UnsupportedEncodingException e) {
            if (MAS.DEBUG) {
                Log.e((String)"PKCE not supported", (String)e.getMessage(), (Throwable)e);
            }
            return null;
        }
    }

    public static MASRequest getLogoutRequest() {
        TokenManager tokenManager = StorageProvider.getInstance().getTokenManager();
        IdToken idToken = tokenManager.getIdToken();
        if (idToken != null) {
            URI uri = ConfigurationManager.getInstance().getConnectedGatewayConfigurationProvider().getTokenUri("msso.url.resource_owner_logout");
            ArrayList<Pair> form = new ArrayList<Pair>();
            form.add(new Pair((Object)"id_token", (Object)tokenManager.getIdToken().getValue()));
            form.add(new Pair((Object)"id_token_type", (Object)tokenManager.getIdToken().getType()));
            form.add(new Pair((Object)"logout_apps", (Object)Boolean.toString(true)));
            return new MASRequest.MASRequestBuilder(uri).post(MASRequestBody.urlEncodedFormBody(form)).responseBody(MASResponseBody.stringBody()).connectionListener(new MASConnectionListener(){

                @Override
                public void onObtained(HttpURLConnection connection) {
                    ClientCredentialContainer container = StorageProvider.getInstance().getClientCredentialContainer();
                    String clientId = container.getClientId();
                    String clientSecret = container.getClientSecret();
                    String header = "Basic " + IoUtils.base64(clientId + ":" + clientSecret, Charsets.ASCII);
                    connection.setRequestProperty("authorization", header);
                }

                @Override
                public void onConnected(HttpURLConnection connection) {
                }
            }).build();
        }
        return null;
    }

    public static MASRequest getRevokeRequest() {
        OAuthTokenContainer tokenContainer = StorageProvider.getInstance().getOAuthTokenContainer();
        String refreshToken = tokenContainer.getRefreshToken();
        if (refreshToken != null) {
            String endpointPath = MASConfiguration.getCurrentConfiguration().getEndpointPath("msso.url.usersession_logout_endpoint_path");
            Uri.Builder uriBuilder = new Uri.Builder().encodedPath(endpointPath);
            uriBuilder.appendQueryParameter("token", tokenContainer.getRefreshToken()).appendQueryParameter("token_type_hint", "refresh_token");
            Uri uri = uriBuilder.build();
            ClientCredentialContainer container = StorageProvider.getInstance().getClientCredentialContainer();
            return new MASRequest.MASRequestBuilder(uri).delete(null).responseBody(MASResponseBody.stringBody()).header("authorization", "Basic " + IoUtils.base64(container.getClientId() + ":" + container.getClientSecret(), Charsets.ASCII)).build();
        }
        return null;
    }
}

