/*
 * Decompiled with CFR 0.152.
 */
package com.ca.mas.core.oauth;

import android.content.Context;
import android.net.Uri;
import android.support.annotation.NonNull;
import android.util.Base64;
import android.util.Pair;
import com.ca.mas.core.client.ServerClient;
import com.ca.mas.core.conf.ConfigurationManager;
import com.ca.mas.core.conf.ConfigurationProvider;
import com.ca.mas.core.context.MssoContext;
import com.ca.mas.core.error.MAGException;
import com.ca.mas.core.http.MAGHttpClient;
import com.ca.mas.core.io.Charsets;
import com.ca.mas.core.io.IoUtils;
import com.ca.mas.core.oauth.CodeVerifierCache;
import com.ca.mas.core.oauth.OAuthClientUtil;
import com.ca.mas.core.oauth.OAuthException;
import com.ca.mas.core.oauth.OAuthServerException;
import com.ca.mas.core.oauth.PKCE;
import com.ca.mas.core.service.AuthenticationProvider;
import com.ca.mas.core.service.Provider;
import com.ca.mas.core.token.IdToken;
import com.ca.mas.foundation.MASRequest;
import com.ca.mas.foundation.MASRequestBody;
import com.ca.mas.foundation.MASResponse;
import com.ca.mas.foundation.MASResponseBody;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.SecureRandom;
import java.util.ArrayList;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class OAuthClient
extends ServerClient {
    private static final int INVALID_CLIENT_CREDENTIALS = 3000201;
    private static final String DEFAULT_DISPLAY = "social_login";
    public static final String RESPONSE_TYPE = "response_type";
    public static final String CODE = "code";
    public static final String DISPLAY = "display";
    public static final String MSSO_REGISTER = "msso_register";
    public static final String REDIRECT_URI = "redirect_uri";
    public static final String IDP = "idp";
    public static final String PROVIDERS = "providers";
    public static final String PROVIDER = "provider";
    public static final String ID = "id";
    public static final String AUTH_URL = "auth_url";
    public static final String POLL_URL = "poll_url";
    public static final String ID_TOKEN = "id_token";
    public static final String TOKEN = "token";
    public static final String ID_TOKEN_TYPE = "id_token_type";
    public static final String TOKEN_TYPE = "token_type_hint";
    public static final String LOGOUT_APPS = "logout_apps";
    public static final String AUTHORIZATION = "authorization";
    public static final String CODE_CHALLENGE = "code_challenge";
    public static final String CODE_CHALLENGE_METHOD = "code_challenge_method";
    public static final String STATE = "state";

    public OAuthClient(MssoContext mssoContext) {
        super(mssoContext);
    }

    public AuthenticationProvider getSocialPlatformProvider(Context context) throws OAuthException, OAuthServerException {
        ArrayList<Provider> spProviders;
        String idp;
        block15: {
            ConfigurationProvider config = this.mssoContext.getConfigurationProvider();
            String redirectUri = (String)config.getProperty("msso.authorize.redirect.uri");
            idp = "enterprise";
            spProviders = new ArrayList<Provider>();
            if (redirectUri != null) {
                PKCE pkce;
                String scope;
                Uri.Builder b = Uri.parse((String)config.getTokenUri("msso.url.authorize").toString()).buildUpon();
                b.appendQueryParameter("client_id", this.mssoContext.getClientId());
                b.appendQueryParameter(RESPONSE_TYPE, CODE);
                b.appendQueryParameter(DISPLAY, DEFAULT_DISPLAY);
                Boolean ssoEnabled = (Boolean)config.getProperty("msso.sso.enabled");
                if (ssoEnabled == null) {
                    ssoEnabled = true;
                }
                if ((scope = config.getClientScope()) == null) {
                    scope = "";
                }
                if (ssoEnabled.booleanValue() && !scope.contains("openid")) {
                    scope = scope + " " + "openid";
                }
                if (!this.mssoContext.isDeviceRegistered() && !scope.contains(MSSO_REGISTER)) {
                    scope = scope + " " + MSSO_REGISTER;
                }
                if (this.mssoContext.isDeviceRegistered()) {
                    scope = scope.replace(MSSO_REGISTER, "");
                }
                if (scope.length() > 0) {
                    b.appendQueryParameter("scope", scope.trim());
                }
                b.appendQueryParameter(REDIRECT_URI, redirectUri);
                if (ConfigurationManager.getInstance().isPKCEEnabled() && (pkce = OAuthClientUtil.generateCodeChallenge()) != null) {
                    b.appendQueryParameter(CODE_CHALLENGE, pkce.codeChallenge);
                    b.appendQueryParameter(CODE_CHALLENGE_METHOD, pkce.codeChallengeMethod);
                    SecureRandom secureRandom = new SecureRandom();
                    byte[] random = new byte[16];
                    secureRandom.nextBytes(random);
                    String key = Base64.encodeToString((byte[])random, (int)11);
                    CodeVerifierCache.getInstance().store(key, pkce.codeVerifier);
                    b.appendQueryParameter(STATE, key);
                }
                MAGHttpClient httpClient = this.mssoContext.getMAGHttpClient();
                try {
                    MASRequest.MASRequestBuilder builder = new MASRequest.MASRequestBuilder(new URI(b.build().toString())).responseBody(MASResponseBody.jsonBody());
                    MASRequest request = builder.build();
                    MASResponse response = httpClient.execute(request);
                    if (response.getResponseCode() == 200) {
                        JSONObject jsonResponse = (JSONObject)response.getBody().getContent();
                        idp = jsonResponse.getString(IDP);
                        JSONArray providers = jsonResponse.getJSONArray(PROVIDERS);
                        for (int i = 0; i < providers.length(); ++i) {
                            JSONObject provider = providers.getJSONObject(i).getJSONObject(PROVIDER);
                            String id = provider.getString(ID);
                            String url = provider.getString(AUTH_URL);
                            String poll = provider.optString(POLL_URL);
                            spProviders.add(new Provider(id, url, poll, context.getResources().getIdentifier("drawable/" + id.toLowerCase(), null, context.getPackageName())));
                        }
                        break block15;
                    }
                    int errorCode = OAuthClient.findErrorCode(response);
                    if (errorCode == 3000201) {
                        this.mssoContext.clearClientCredentials();
                    }
                    throw ServerClient.createServerException(response, OAuthServerException.class);
                }
                catch (IOException e) {
                    throw new OAuthException(-1, "Unable to retrieve Social Login Providers: " + e.getMessage(), e);
                }
                catch (JSONException e) {
                    throw new OAuthException(-1, "response from " + b.toString() + " was not valid response: " + e.getMessage(), e);
                }
                catch (URISyntaxException e) {
                    throw new OAuthException(-1, (Throwable)e);
                }
            }
        }
        return new AuthenticationProvider(idp, spProviders);
    }

    public void logout(@NonNull IdToken idToken, @NonNull String clientId, @NonNull String clientSecret, boolean logoutApps) throws OAuthServerException, OAuthException {
        ArrayList<Pair> form = new ArrayList<Pair>();
        form.add(new Pair((Object)ID_TOKEN, (Object)idToken.getValue()));
        form.add(new Pair((Object)ID_TOKEN_TYPE, (Object)idToken.getType()));
        form.add(new Pair((Object)LOGOUT_APPS, (Object)Boolean.toString(logoutApps)));
        URI uri = this.conf.getTokenUri("msso.url.resource_owner_logout");
        MASRequest request = new MASRequest.MASRequestBuilder(uri).post(MASRequestBody.urlEncodedFormBody(form)).responseBody(MASResponseBody.stringBody()).header(AUTHORIZATION, "Basic " + IoUtils.base64(clientId + ":" + clientSecret, Charsets.ASCII)).build();
        try {
            this.obtainServerResponseToPostedForm(request);
        }
        catch (MAGException e) {
            throw new OAuthException(-1, (Throwable)e);
        }
        catch (OAuthServerException e) {
            if (e.getErrorCode() == 3000201) {
                this.mssoContext.clearClientCredentials();
            }
            throw e;
        }
    }
}

