/*
 * Decompiled with CFR 0.152.
 */
package com.ca.mas.core.http;

import com.ca.mas.core.io.Charsets;
import java.nio.charset.Charset;

public class ContentType {
    public static final ContentType APPLICATION_OCTET_STREAM = new ContentType("application/octet-stream", null);
    public static final ContentType APPLICATION_FORM_URLENCODED = new ContentType("application/x-www-form-urlencoded", Charsets.ISO_8859_1);
    public static final ContentType APPLICATION_JSON = new ContentType("application/json", Charsets.UTF8);
    public static final ContentType TEXT_PLAIN = new ContentType("text/plain", Charsets.ISO_8859_1);
    private final String mimeType;
    private final Charset charset;

    public ContentType(String mimeType, Charset charset) {
        this.mimeType = mimeType;
        this.charset = charset;
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public Charset getCharset() {
        return this.charset;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.mimeType);
        if (this.charset != null) {
            sb.append("; charset=");
            sb.append(this.charset.name());
        }
        return sb.toString();
    }
}

