/*
 * Decompiled with CFR 0.152.
 */
package com.ca.mas.foundation;

import android.util.Log;
import com.ca.mas.foundation.MAS;
import com.ca.mas.foundation.MASExtension;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;

public class Extension {
    private static <T> T getDefaultImpl(Class<T> tClass) {
        return (T)Proxy.newProxyInstance(tClass.getClassLoader(), new Class[]{tClass}, new InvocationHandler(){

            @Override
            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                throw new UnsupportedOperationException("Stub! Please provide module dependency.");
            }
        });
    }

    private Extension() {
    }

    static void inject(Object instance) {
        for (Field field : instance.getClass().getDeclaredFields()) {
            if (!field.isAnnotationPresent(MASExtension.class)) continue;
            field.setAccessible(true);
            try {
                Constructor<?> constructor = Class.forName(field.getType().getName() + "Impl").getConstructor(new Class[0]);
                field.set(instance, constructor.newInstance(new Object[0]));
            }
            catch (Exception e) {
                try {
                    field.set(instance, Extension.getDefaultImpl(field.getType()));
                }
                catch (IllegalAccessException ignore) {
                    if (!MAS.DEBUG) continue;
                    Log.w((String)"MAS", (String)"Failed to inject module implementation.", (Throwable)ignore);
                }
            }
        }
    }
}

